/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyRestrictionContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionContract;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionRequireBase;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionUpdateContract;

public final class PolicyRestrictionContractImpl
implements PolicyRestrictionContract,
PolicyRestrictionContract.Definition,
PolicyRestrictionContract.Update {
    private PolicyRestrictionContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String policyRestrictionId;
    private String createIfMatch;
    private String updateIfMatch;
    private PolicyRestrictionUpdateContract updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String scope() {
        return this.innerModel().scope();
    }

    @Override
    public PolicyRestrictionRequireBase requireBase() {
        return this.innerModel().requireBase();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PolicyRestrictionContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public PolicyRestrictionContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public PolicyRestrictionContract create() {
        this.innerObject = this.serviceManager.serviceClient().getPolicyRestrictions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.policyRestrictionId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public PolicyRestrictionContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPolicyRestrictions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.policyRestrictionId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    PolicyRestrictionContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new PolicyRestrictionContractInner();
        this.serviceManager = serviceManager;
        this.policyRestrictionId = name;
        this.createIfMatch = null;
    }

    @Override
    public PolicyRestrictionContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new PolicyRestrictionUpdateContract();
        return this;
    }

    @Override
    public PolicyRestrictionContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getPolicyRestrictions().updateWithResponse(this.resourceGroupName, this.serviceName, this.policyRestrictionId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public PolicyRestrictionContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPolicyRestrictions().updateWithResponse(this.resourceGroupName, this.serviceName, this.policyRestrictionId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    PolicyRestrictionContractImpl(PolicyRestrictionContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.policyRestrictionId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "policyRestrictions");
    }

    @Override
    public PolicyRestrictionContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getPolicyRestrictions().getWithResponse(this.resourceGroupName, this.serviceName, this.policyRestrictionId, Context.NONE).getValue();
        return this;
    }

    @Override
    public PolicyRestrictionContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPolicyRestrictions().getWithResponse(this.resourceGroupName, this.serviceName, this.policyRestrictionId, context).getValue();
        return this;
    }

    @Override
    public PolicyRestrictionContractImpl withScope(String scope) {
        if (this.isInCreateMode()) {
            this.innerModel().withScope(scope);
            return this;
        }
        this.updateParameters.withScope(scope);
        return this;
    }

    @Override
    public PolicyRestrictionContractImpl withRequireBase(PolicyRestrictionRequireBase requireBase) {
        if (this.isInCreateMode()) {
            this.innerModel().withRequireBase(requireBase);
            return this;
        }
        this.updateParameters.withRequireBase(requireBase);
        return this;
    }

    @Override
    public PolicyRestrictionContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

