/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.PolicyRestrictionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyRestrictionContractInner;
import com.azure.resourcemanager.apimanagement.implementation.PolicyRestrictionContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionContract;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictions;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionsGetResponse;

public final class PolicyRestrictionsImpl
implements PolicyRestrictions {
    private static final ClientLogger LOGGER = new ClientLogger(PolicyRestrictionsImpl.class);
    private final PolicyRestrictionsClient innerClient;
    private final ApiManagementManager serviceManager;

    public PolicyRestrictionsImpl(PolicyRestrictionsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PolicyRestrictionContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<PolicyRestrictionContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyRestrictionContractImpl((PolicyRestrictionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PolicyRestrictionContract> listByService(String resourceGroupName, String serviceName, Context context) {
        PagedIterable<PolicyRestrictionContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyRestrictionContractImpl((PolicyRestrictionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PolicyRestrictionsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String policyRestrictionId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, policyRestrictionId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String policyRestrictionId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, policyRestrictionId);
    }

    @Override
    public Response<PolicyRestrictionContract> getWithResponse(String resourceGroupName, String serviceName, String policyRestrictionId, Context context) {
        PolicyRestrictionsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, policyRestrictionId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyRestrictionContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyRestrictionContract get(String resourceGroupName, String serviceName, String policyRestrictionId) {
        PolicyRestrictionContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, policyRestrictionId);
        if (inner != null) {
            return new PolicyRestrictionContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String policyRestrictionId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, policyRestrictionId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String policyRestrictionId) {
        this.serviceClient().delete(resourceGroupName, serviceName, policyRestrictionId);
    }

    @Override
    public PolicyRestrictionContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String policyRestrictionId = ResourceManagerUtils.getValueFromIdByName(id, "policyRestrictions");
        if (policyRestrictionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'policyRestrictions'.", id)));
        }
        return (PolicyRestrictionContract)this.getWithResponse(resourceGroupName, serviceName, policyRestrictionId, Context.NONE).getValue();
    }

    @Override
    public Response<PolicyRestrictionContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String policyRestrictionId = ResourceManagerUtils.getValueFromIdByName(id, "policyRestrictions");
        if (policyRestrictionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'policyRestrictions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, policyRestrictionId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String policyRestrictionId = ResourceManagerUtils.getValueFromIdByName(id, "policyRestrictions");
        if (policyRestrictionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'policyRestrictions'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, policyRestrictionId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String policyRestrictionId = ResourceManagerUtils.getValueFromIdByName(id, "policyRestrictions");
        if (policyRestrictionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'policyRestrictions'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, policyRestrictionId, ifMatch, context);
    }

    private PolicyRestrictionsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public PolicyRestrictionContractImpl define(String name) {
        return new PolicyRestrictionContractImpl(name, this.manager());
    }
}

