/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalRevisionContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionContract;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionStatus;
import java.time.OffsetDateTime;

public final class PortalRevisionContractImpl
implements PortalRevisionContract,
PortalRevisionContract.Definition,
PortalRevisionContract.Update {
    private PortalRevisionContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String portalRevisionId;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String statusDetails() {
        return this.innerModel().statusDetails();
    }

    @Override
    public PortalRevisionStatus status() {
        return this.innerModel().status();
    }

    @Override
    public Boolean isCurrent() {
        return this.innerModel().isCurrent();
    }

    @Override
    public OffsetDateTime createdDateTime() {
        return this.innerModel().createdDateTime();
    }

    @Override
    public OffsetDateTime updatedDateTime() {
        return this.innerModel().updatedDateTime();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PortalRevisionContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public PortalRevisionContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public PortalRevisionContract create() {
        this.innerObject = this.serviceManager.serviceClient().getPortalRevisions().createOrUpdate(this.resourceGroupName, this.serviceName, this.portalRevisionId, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PortalRevisionContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPortalRevisions().createOrUpdate(this.resourceGroupName, this.serviceName, this.portalRevisionId, this.innerModel(), context);
        return this;
    }

    PortalRevisionContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new PortalRevisionContractInner();
        this.serviceManager = serviceManager;
        this.portalRevisionId = name;
    }

    @Override
    public PortalRevisionContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public PortalRevisionContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getPortalRevisions().update(this.resourceGroupName, this.serviceName, this.portalRevisionId, this.updateIfMatch, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PortalRevisionContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPortalRevisions().update(this.resourceGroupName, this.serviceName, this.portalRevisionId, this.updateIfMatch, this.innerModel(), context);
        return this;
    }

    PortalRevisionContractImpl(PortalRevisionContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.portalRevisionId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "portalRevisions");
    }

    @Override
    public PortalRevisionContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getPortalRevisions().getWithResponse(this.resourceGroupName, this.serviceName, this.portalRevisionId, Context.NONE).getValue();
        return this;
    }

    @Override
    public PortalRevisionContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPortalRevisions().getWithResponse(this.resourceGroupName, this.serviceName, this.portalRevisionId, context).getValue();
        return this;
    }

    @Override
    public PortalRevisionContractImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public PortalRevisionContractImpl withIsCurrent(Boolean isCurrent) {
        this.innerModel().withIsCurrent(isCurrent);
        return this;
    }

    @Override
    public PortalRevisionContractImpl withIfMatch(String ifMatch) {
        this.updateIfMatch = ifMatch;
        return this;
    }
}

