/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.PortalRevisionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalRevisionContractInner;
import com.azure.resourcemanager.apimanagement.implementation.PortalRevisionContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionContract;
import com.azure.resourcemanager.apimanagement.models.PortalRevisions;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionsGetResponse;

public final class PortalRevisionsImpl
implements PortalRevisions {
    private static final ClientLogger LOGGER = new ClientLogger(PortalRevisionsImpl.class);
    private final PortalRevisionsClient innerClient;
    private final ApiManagementManager serviceManager;

    public PortalRevisionsImpl(PortalRevisionsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PortalRevisionContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<PortalRevisionContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PortalRevisionContractImpl((PortalRevisionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PortalRevisionContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<PortalRevisionContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PortalRevisionContractImpl((PortalRevisionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PortalRevisionsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String portalRevisionId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, portalRevisionId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String portalRevisionId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, portalRevisionId);
    }

    @Override
    public Response<PortalRevisionContract> getWithResponse(String resourceGroupName, String serviceName, String portalRevisionId, Context context) {
        PortalRevisionsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, portalRevisionId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PortalRevisionContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PortalRevisionContract get(String resourceGroupName, String serviceName, String portalRevisionId) {
        PortalRevisionContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, portalRevisionId);
        if (inner != null) {
            return new PortalRevisionContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PortalRevisionContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String portalRevisionId = ResourceManagerUtils.getValueFromIdByName(id, "portalRevisions");
        if (portalRevisionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'portalRevisions'.", id)));
        }
        return (PortalRevisionContract)this.getWithResponse(resourceGroupName, serviceName, portalRevisionId, Context.NONE).getValue();
    }

    @Override
    public Response<PortalRevisionContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String portalRevisionId = ResourceManagerUtils.getValueFromIdByName(id, "portalRevisions");
        if (portalRevisionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'portalRevisions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, portalRevisionId, context);
    }

    private PortalRevisionsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public PortalRevisionContractImpl define(String name) {
        return new PortalRevisionContractImpl(name, this.manager());
    }
}

