/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductApiLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinkContract;

public final class ProductApiLinkContractImpl
implements ProductApiLinkContract,
ProductApiLinkContract.Definition,
ProductApiLinkContract.Update {
    private ProductApiLinkContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String productId;
    private String apiLinkId;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String apiId() {
        return this.innerModel().apiId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ProductApiLinkContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProductApiLinkContractImpl withExistingProduct(String resourceGroupName, String serviceName, String productId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.productId = productId;
        return this;
    }

    @Override
    public ProductApiLinkContract create() {
        this.innerObject = (ProductApiLinkContractInner)((Object)this.serviceManager.serviceClient().getProductApiLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.apiLinkId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ProductApiLinkContract create(Context context) {
        this.innerObject = (ProductApiLinkContractInner)((Object)this.serviceManager.serviceClient().getProductApiLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.apiLinkId, this.innerModel(), context).getValue());
        return this;
    }

    ProductApiLinkContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ProductApiLinkContractInner();
        this.serviceManager = serviceManager;
        this.apiLinkId = name;
    }

    @Override
    public ProductApiLinkContractImpl update() {
        return this;
    }

    @Override
    public ProductApiLinkContract apply() {
        this.innerObject = (ProductApiLinkContractInner)((Object)this.serviceManager.serviceClient().getProductApiLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.apiLinkId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ProductApiLinkContract apply(Context context) {
        this.innerObject = (ProductApiLinkContractInner)((Object)this.serviceManager.serviceClient().getProductApiLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.apiLinkId, this.innerModel(), context).getValue());
        return this;
    }

    ProductApiLinkContractImpl(ProductApiLinkContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.productId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "products");
        this.apiLinkId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apiLinks");
    }

    @Override
    public ProductApiLinkContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getProductApiLinks().getWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.apiLinkId, Context.NONE).getValue();
        return this;
    }

    @Override
    public ProductApiLinkContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getProductApiLinks().getWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.apiLinkId, context).getValue();
        return this;
    }

    @Override
    public ProductApiLinkContractImpl withApiId(String apiId) {
        this.innerModel().withApiId(apiId);
        return this;
    }
}

