/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ProductApiLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductApiLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ProductApiLinkContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinkContract;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinks;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinksGetResponse;

public final class ProductApiLinksImpl
implements ProductApiLinks {
    private static final ClientLogger LOGGER = new ClientLogger(ProductApiLinksImpl.class);
    private final ProductApiLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public ProductApiLinksImpl(ProductApiLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ProductApiLinkContract> listByProduct(String resourceGroupName, String serviceName, String productId) {
        PagedIterable<ProductApiLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductApiLinkContractImpl((ProductApiLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProductApiLinkContract> listByProduct(String resourceGroupName, String serviceName, String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ProductApiLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductApiLinkContractImpl((ProductApiLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ProductApiLinkContract> getWithResponse(String resourceGroupName, String serviceName, String productId, String apiLinkId, Context context) {
        ProductApiLinksGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, productId, apiLinkId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProductApiLinkContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ProductApiLinkContract get(String resourceGroupName, String serviceName, String productId, String apiLinkId) {
        ProductApiLinkContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, productId, apiLinkId);
        if (inner != null) {
            return new ProductApiLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String productId, String apiLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, productId, apiLinkId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String productId, String apiLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, productId, apiLinkId);
    }

    @Override
    public ProductApiLinkContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        return (ProductApiLinkContract)this.getWithResponse(resourceGroupName, serviceName, productId, apiLinkId, Context.NONE).getValue();
    }

    @Override
    public Response<ProductApiLinkContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, productId, apiLinkId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, productId, apiLinkId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, productId, apiLinkId, context);
    }

    private ProductApiLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProductApiLinkContractImpl define(String name) {
        return new ProductApiLinkContractImpl(name, this.manager());
    }
}

