/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ProductApisClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiContract;
import com.azure.resourcemanager.apimanagement.models.ProductApis;

public final class ProductApisImpl
implements ProductApis {
    private static final ClientLogger LOGGER = new ClientLogger(ProductApisImpl.class);
    private final ProductApisClient innerClient;
    private final ApiManagementManager serviceManager;

    public ProductApisImpl(ProductApisClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApiContract> listByProduct(String resourceGroupName, String serviceName, String productId) {
        PagedIterable<ApiContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiContractImpl((ApiContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiContract> listByProduct(String resourceGroupName, String serviceName, String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ApiContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiContractImpl((ApiContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Void> checkEntityExistsWithResponse(String resourceGroupName, String serviceName, String productId, String apiId, Context context) {
        return this.serviceClient().checkEntityExistsWithResponse(resourceGroupName, serviceName, productId, apiId, context);
    }

    @Override
    public void checkEntityExists(String resourceGroupName, String serviceName, String productId, String apiId) {
        this.serviceClient().checkEntityExists(resourceGroupName, serviceName, productId, apiId);
    }

    @Override
    public Response<ApiContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String productId, String apiId, Context context) {
        Response<ApiContractInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, productId, apiId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiContractImpl((ApiContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ApiContract createOrUpdate(String resourceGroupName, String serviceName, String productId, String apiId) {
        ApiContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, productId, apiId);
        if (inner != null) {
            return new ApiContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String productId, String apiId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, productId, apiId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String productId, String apiId) {
        this.serviceClient().delete(resourceGroupName, serviceName, productId, apiId);
    }

    private ProductApisClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

