/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ProductContract;
import com.azure.resourcemanager.apimanagement.models.ProductState;
import com.azure.resourcemanager.apimanagement.models.ProductUpdateParameters;

public final class ProductContractImpl
implements ProductContract,
ProductContract.Definition,
ProductContract.Update {
    private ProductContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String productId;
    private String createIfMatch;
    private String updateIfMatch;
    private ProductUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String terms() {
        return this.innerModel().terms();
    }

    @Override
    public Boolean subscriptionRequired() {
        return this.innerModel().subscriptionRequired();
    }

    @Override
    public Boolean approvalRequired() {
        return this.innerModel().approvalRequired();
    }

    @Override
    public Integer subscriptionsLimit() {
        return this.innerModel().subscriptionsLimit();
    }

    @Override
    public ProductState state() {
        return this.innerModel().state();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ProductContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProductContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public ProductContract create() {
        this.innerObject = this.serviceManager.serviceClient().getProducts().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public ProductContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getProducts().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    ProductContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ProductContractInner();
        this.serviceManager = serviceManager;
        this.productId = name;
        this.createIfMatch = null;
    }

    @Override
    public ProductContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new ProductUpdateParameters();
        return this;
    }

    @Override
    public ProductContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getProducts().updateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public ProductContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getProducts().updateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    ProductContractImpl(ProductContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.productId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "products");
    }

    @Override
    public ProductContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getProducts().getWithResponse(this.resourceGroupName, this.serviceName, this.productId, Context.NONE).getValue();
        return this;
    }

    @Override
    public ProductContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getProducts().getWithResponse(this.resourceGroupName, this.serviceName, this.productId, context).getValue();
        return this;
    }

    @Override
    public ProductContractImpl withDisplayName(String displayName) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        }
        this.updateParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public ProductContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public ProductContractImpl withTerms(String terms) {
        if (this.isInCreateMode()) {
            this.innerModel().withTerms(terms);
            return this;
        }
        this.updateParameters.withTerms(terms);
        return this;
    }

    @Override
    public ProductContractImpl withSubscriptionRequired(Boolean subscriptionRequired) {
        if (this.isInCreateMode()) {
            this.innerModel().withSubscriptionRequired(subscriptionRequired);
            return this;
        }
        this.updateParameters.withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    @Override
    public ProductContractImpl withApprovalRequired(Boolean approvalRequired) {
        if (this.isInCreateMode()) {
            this.innerModel().withApprovalRequired(approvalRequired);
            return this;
        }
        this.updateParameters.withApprovalRequired(approvalRequired);
        return this;
    }

    @Override
    public ProductContractImpl withSubscriptionsLimit(Integer subscriptionsLimit) {
        if (this.isInCreateMode()) {
            this.innerModel().withSubscriptionsLimit(subscriptionsLimit);
            return this;
        }
        this.updateParameters.withSubscriptionsLimit(subscriptionsLimit);
        return this;
    }

    @Override
    public ProductContractImpl withState(ProductState state) {
        if (this.isInCreateMode()) {
            this.innerModel().withState(state);
            return this;
        }
        this.updateParameters.withState(state);
        return this;
    }

    @Override
    public ProductContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

