/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ProductGroupLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductGroupLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ProductGroupLinkContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ProductGroupLinkContract;
import com.azure.resourcemanager.apimanagement.models.ProductGroupLinks;
import com.azure.resourcemanager.apimanagement.models.ProductGroupLinksGetResponse;

public final class ProductGroupLinksImpl
implements ProductGroupLinks {
    private static final ClientLogger LOGGER = new ClientLogger(ProductGroupLinksImpl.class);
    private final ProductGroupLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public ProductGroupLinksImpl(ProductGroupLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ProductGroupLinkContract> listByProduct(String resourceGroupName, String serviceName, String productId) {
        PagedIterable<ProductGroupLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductGroupLinkContractImpl((ProductGroupLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProductGroupLinkContract> listByProduct(String resourceGroupName, String serviceName, String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ProductGroupLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductGroupLinkContractImpl((ProductGroupLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ProductGroupLinkContract> getWithResponse(String resourceGroupName, String serviceName, String productId, String groupLinkId, Context context) {
        ProductGroupLinksGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, productId, groupLinkId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProductGroupLinkContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ProductGroupLinkContract get(String resourceGroupName, String serviceName, String productId, String groupLinkId) {
        ProductGroupLinkContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, productId, groupLinkId);
        if (inner != null) {
            return new ProductGroupLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String productId, String groupLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, productId, groupLinkId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String productId, String groupLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, productId, groupLinkId);
    }

    @Override
    public ProductGroupLinkContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String groupLinkId = ResourceManagerUtils.getValueFromIdByName(id, "groupLinks");
        if (groupLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'groupLinks'.", id)));
        }
        return (ProductGroupLinkContract)this.getWithResponse(resourceGroupName, serviceName, productId, groupLinkId, Context.NONE).getValue();
    }

    @Override
    public Response<ProductGroupLinkContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String groupLinkId = ResourceManagerUtils.getValueFromIdByName(id, "groupLinks");
        if (groupLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'groupLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, productId, groupLinkId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String groupLinkId = ResourceManagerUtils.getValueFromIdByName(id, "groupLinks");
        if (groupLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'groupLinks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, productId, groupLinkId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String groupLinkId = ResourceManagerUtils.getValueFromIdByName(id, "groupLinks");
        if (groupLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'groupLinks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, productId, groupLinkId, context);
    }

    private ProductGroupLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProductGroupLinkContractImpl define(String name) {
        return new ProductGroupLinkContractImpl(name, this.manager());
    }
}

