/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ProductSubscriptionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.SubscriptionContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.SubscriptionContractImpl;
import com.azure.resourcemanager.apimanagement.models.ProductSubscriptions;
import com.azure.resourcemanager.apimanagement.models.SubscriptionContract;

public final class ProductSubscriptionsImpl
implements ProductSubscriptions {
    private static final ClientLogger LOGGER = new ClientLogger(ProductSubscriptionsImpl.class);
    private final ProductSubscriptionsClient innerClient;
    private final ApiManagementManager serviceManager;

    public ProductSubscriptionsImpl(ProductSubscriptionsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SubscriptionContract> list(String resourceGroupName, String serviceName, String productId) {
        PagedIterable<SubscriptionContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubscriptionContractImpl((SubscriptionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SubscriptionContract> list(String resourceGroupName, String serviceName, String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<SubscriptionContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubscriptionContractImpl((SubscriptionContractInner)((Object)inner1), this.manager()));
    }

    private ProductSubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

