/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.ProductWikisOperationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.WikiContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.ProductWikisOperationsListHeaders;
import com.azure.resourcemanager.apimanagement.models.ProductWikisOperationsListNextHeaders;
import com.azure.resourcemanager.apimanagement.models.ProductWikisOperationsListNextResponse;
import com.azure.resourcemanager.apimanagement.models.ProductWikisOperationsListResponse;
import reactor.core.publisher.Mono;

public final class ProductWikisOperationsClientImpl
implements ProductWikisOperationsClient {
    private final ProductWikisOperationsService service;
    private final ApiManagementClientImpl client;

    ProductWikisOperationsClientImpl(ApiManagementClientImpl client) {
        this.service = (ProductWikisOperationsService)RestProxy.create(ProductWikisOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WikiContractInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String productId, String filter, Integer top, Integer skip) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (productId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter productId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, productId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), (Object)((ProductWikisOperationsListHeaders)res.getDeserializedHeaders()))).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WikiContractInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String productId, String filter, Integer top, Integer skip, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (productId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter productId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, productId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), (Object)((ProductWikisOperationsListHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WikiContractInner> listAsync(String resourceGroupName, String serviceName, String productId, String filter, Integer top, Integer skip) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, productId, filter, top, skip), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WikiContractInner> listAsync(String resourceGroupName, String serviceName, String productId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, productId, filter, top, skip), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WikiContractInner> listAsync(String resourceGroupName, String serviceName, String productId, String filter, Integer top, Integer skip, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, productId, filter, top, skip, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WikiContractInner> list(String resourceGroupName, String serviceName, String productId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, productId, filter, top, skip));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WikiContractInner> list(String resourceGroupName, String serviceName, String productId, String filter, Integer top, Integer skip, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, productId, filter, top, skip, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WikiContractInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), (Object)((ProductWikisOperationsListNextHeaders)res.getDeserializedHeaders()))).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WikiContractInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), (Object)((ProductWikisOperationsListNextHeaders)res.getDeserializedHeaders())));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientP")
    public static interface ProductWikisOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/wikis")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<ProductWikisOperationsListResponse> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @QueryParam(value="$filter") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$skip") Integer var6, @PathParam(value="productId") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<ProductWikisOperationsListNextResponse> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

