/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.QuotaByCounterKeysClient;
import com.azure.resourcemanager.apimanagement.fluent.models.QuotaCounterCollectionInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.QuotaCounterValueUpdateContract;
import reactor.core.publisher.Mono;

public final class QuotaByCounterKeysClientImpl
implements QuotaByCounterKeysClient {
    private final QuotaByCounterKeysService service;
    private final ApiManagementClientImpl client;

    QuotaByCounterKeysClientImpl(ApiManagementClientImpl client) {
        this.service = (QuotaByCounterKeysService)RestProxy.create(QuotaByCounterKeysService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QuotaCounterCollectionInner>> listByServiceWithResponseAsync(String resourceGroupName, String serviceName, String quotaCounterKey) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (quotaCounterKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaCounterKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByService(this.client.getEndpoint(), resourceGroupName, serviceName, quotaCounterKey, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QuotaCounterCollectionInner>> listByServiceWithResponseAsync(String resourceGroupName, String serviceName, String quotaCounterKey, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (quotaCounterKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaCounterKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByService(this.client.getEndpoint(), resourceGroupName, serviceName, quotaCounterKey, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<QuotaCounterCollectionInner> listByServiceAsync(String resourceGroupName, String serviceName, String quotaCounterKey) {
        return this.listByServiceWithResponseAsync(resourceGroupName, serviceName, quotaCounterKey).flatMap(res -> Mono.justOrEmpty((Object)((QuotaCounterCollectionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QuotaCounterCollectionInner> listByServiceWithResponse(String resourceGroupName, String serviceName, String quotaCounterKey, Context context) {
        return (Response)this.listByServiceWithResponseAsync(resourceGroupName, serviceName, quotaCounterKey, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public QuotaCounterCollectionInner listByService(String resourceGroupName, String serviceName, String quotaCounterKey) {
        return (QuotaCounterCollectionInner)this.listByServiceWithResponse(resourceGroupName, serviceName, quotaCounterKey, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QuotaCounterCollectionInner>> updateWithResponseAsync(String resourceGroupName, String serviceName, String quotaCounterKey, QuotaCounterValueUpdateContract parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (quotaCounterKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaCounterKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, quotaCounterKey, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QuotaCounterCollectionInner>> updateWithResponseAsync(String resourceGroupName, String serviceName, String quotaCounterKey, QuotaCounterValueUpdateContract parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (quotaCounterKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaCounterKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, quotaCounterKey, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<QuotaCounterCollectionInner> updateAsync(String resourceGroupName, String serviceName, String quotaCounterKey, QuotaCounterValueUpdateContract parameters) {
        return this.updateWithResponseAsync(resourceGroupName, serviceName, quotaCounterKey, parameters).flatMap(res -> Mono.justOrEmpty((Object)((QuotaCounterCollectionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QuotaCounterCollectionInner> updateWithResponse(String resourceGroupName, String serviceName, String quotaCounterKey, QuotaCounterValueUpdateContract parameters, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, serviceName, quotaCounterKey, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public QuotaCounterCollectionInner update(String resourceGroupName, String serviceName, String quotaCounterKey, QuotaCounterValueUpdateContract parameters) {
        return (QuotaCounterCollectionInner)this.updateWithResponse(resourceGroupName, serviceName, quotaCounterKey, parameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientQ")
    public static interface QuotaByCounterKeysService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QuotaCounterCollectionInner>> listByService(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="quotaCounterKey") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QuotaCounterCollectionInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="quotaCounterKey") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") QuotaCounterValueUpdateContract var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

