/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.RegionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.RegionContractInner;
import com.azure.resourcemanager.apimanagement.implementation.RegionContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.RegionContract;
import com.azure.resourcemanager.apimanagement.models.Regions;

public final class RegionsImpl
implements Regions {
    private static final ClientLogger LOGGER = new ClientLogger(RegionsImpl.class);
    private final RegionsClient innerClient;
    private final ApiManagementManager serviceManager;

    public RegionsImpl(RegionsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<RegionContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<RegionContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RegionContractImpl((RegionContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<RegionContract> listByService(String resourceGroupName, String serviceName, Context context) {
        PagedIterable<RegionContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RegionContractImpl((RegionContractInner)inner1, this.manager()));
    }

    private RegionsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

