/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ConnectivityCheckResponseInner;
import com.azure.resourcemanager.apimanagement.implementation.ConnectivityCheckResponseImpl;
import com.azure.resourcemanager.apimanagement.models.ConnectivityCheckRequest;
import com.azure.resourcemanager.apimanagement.models.ConnectivityCheckResponse;
import com.azure.resourcemanager.apimanagement.models.ResourceProviders;

public final class ResourceProvidersImpl
implements ResourceProviders {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersImpl.class);
    private final ResourceProvidersClient innerClient;
    private final ApiManagementManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public ConnectivityCheckResponse performConnectivityCheckAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams) {
        ConnectivityCheckResponseInner inner = this.serviceClient().performConnectivityCheckAsync(resourceGroupName, serviceName, connectivityCheckRequestParams);
        if (inner != null) {
            return new ConnectivityCheckResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ConnectivityCheckResponse performConnectivityCheckAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams, Context context) {
        ConnectivityCheckResponseInner inner = this.serviceClient().performConnectivityCheckAsync(resourceGroupName, serviceName, connectivityCheckRequestParams, context);
        if (inner != null) {
            return new ConnectivityCheckResponseImpl(inner, this.manager());
        }
        return null;
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

