/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.SignUpSettingsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalSignupSettingsInner;
import com.azure.resourcemanager.apimanagement.implementation.PortalSignupSettingsImpl;
import com.azure.resourcemanager.apimanagement.models.PortalSignupSettings;
import com.azure.resourcemanager.apimanagement.models.SignUpSettings;
import com.azure.resourcemanager.apimanagement.models.SignUpSettingsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.SignUpSettingsGetResponse;

public final class SignUpSettingsImpl
implements SignUpSettings {
    private static final ClientLogger LOGGER = new ClientLogger(SignUpSettingsImpl.class);
    private final SignUpSettingsClient innerClient;
    private final ApiManagementManager serviceManager;

    public SignUpSettingsImpl(SignUpSettingsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public SignUpSettingsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName);
    }

    @Override
    public Response<PortalSignupSettings> getWithResponse(String resourceGroupName, String serviceName, Context context) {
        SignUpSettingsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PortalSignupSettingsImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PortalSignupSettings get(String resourceGroupName, String serviceName) {
        PortalSignupSettingsInner inner = this.serviceClient().get(resourceGroupName, serviceName);
        if (inner != null) {
            return new PortalSignupSettingsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> updateWithResponse(String resourceGroupName, String serviceName, String ifMatch, PortalSignupSettingsInner parameters, Context context) {
        return this.serviceClient().updateWithResponse(resourceGroupName, serviceName, ifMatch, parameters, context);
    }

    @Override
    public void update(String resourceGroupName, String serviceName, String ifMatch, PortalSignupSettingsInner parameters) {
        this.serviceClient().update(resourceGroupName, serviceName, ifMatch, parameters);
    }

    @Override
    public Response<PortalSignupSettings> createOrUpdateWithResponse(String resourceGroupName, String serviceName, PortalSignupSettingsInner parameters, String ifMatch, Context context) {
        Response<PortalSignupSettingsInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PortalSignupSettingsImpl((PortalSignupSettingsInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PortalSignupSettings createOrUpdate(String resourceGroupName, String serviceName, PortalSignupSettingsInner parameters) {
        PortalSignupSettingsInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, parameters);
        if (inner != null) {
            return new PortalSignupSettingsImpl(inner, this.manager());
        }
        return null;
    }

    private SignUpSettingsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

