/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.TagApiLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.TagApiLinkContract;

public final class TagApiLinkContractImpl
implements TagApiLinkContract,
TagApiLinkContract.Definition,
TagApiLinkContract.Update {
    private TagApiLinkContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String tagId;
    private String apiLinkId;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String apiId() {
        return this.innerModel().apiId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public TagApiLinkContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public TagApiLinkContractImpl withExistingTag(String resourceGroupName, String serviceName, String tagId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.tagId = tagId;
        return this;
    }

    @Override
    public TagApiLinkContract create() {
        this.innerObject = (TagApiLinkContractInner)((Object)this.serviceManager.serviceClient().getTagApiLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.apiLinkId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public TagApiLinkContract create(Context context) {
        this.innerObject = (TagApiLinkContractInner)((Object)this.serviceManager.serviceClient().getTagApiLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.apiLinkId, this.innerModel(), context).getValue());
        return this;
    }

    TagApiLinkContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new TagApiLinkContractInner();
        this.serviceManager = serviceManager;
        this.apiLinkId = name;
    }

    @Override
    public TagApiLinkContractImpl update() {
        return this;
    }

    @Override
    public TagApiLinkContract apply() {
        this.innerObject = (TagApiLinkContractInner)((Object)this.serviceManager.serviceClient().getTagApiLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.apiLinkId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public TagApiLinkContract apply(Context context) {
        this.innerObject = (TagApiLinkContractInner)((Object)this.serviceManager.serviceClient().getTagApiLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.apiLinkId, this.innerModel(), context).getValue());
        return this;
    }

    TagApiLinkContractImpl(TagApiLinkContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.tagId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tags");
        this.apiLinkId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apiLinks");
    }

    @Override
    public TagApiLinkContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getTagApiLinks().getWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.apiLinkId, Context.NONE).getValue();
        return this;
    }

    @Override
    public TagApiLinkContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTagApiLinks().getWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.apiLinkId, context).getValue();
        return this;
    }

    @Override
    public TagApiLinkContractImpl withApiId(String apiId) {
        this.innerModel().withApiId(apiId);
        return this;
    }
}

