/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.TagProductLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.TagProductLinkContract;

public final class TagProductLinkContractImpl
implements TagProductLinkContract,
TagProductLinkContract.Definition,
TagProductLinkContract.Update {
    private TagProductLinkContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String tagId;
    private String productLinkId;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String productId() {
        return this.innerModel().productId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public TagProductLinkContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public TagProductLinkContractImpl withExistingTag(String resourceGroupName, String serviceName, String tagId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.tagId = tagId;
        return this;
    }

    @Override
    public TagProductLinkContract create() {
        this.innerObject = (TagProductLinkContractInner)((Object)this.serviceManager.serviceClient().getTagProductLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.productLinkId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public TagProductLinkContract create(Context context) {
        this.innerObject = (TagProductLinkContractInner)((Object)this.serviceManager.serviceClient().getTagProductLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.productLinkId, this.innerModel(), context).getValue());
        return this;
    }

    TagProductLinkContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new TagProductLinkContractInner();
        this.serviceManager = serviceManager;
        this.productLinkId = name;
    }

    @Override
    public TagProductLinkContractImpl update() {
        return this;
    }

    @Override
    public TagProductLinkContract apply() {
        this.innerObject = (TagProductLinkContractInner)((Object)this.serviceManager.serviceClient().getTagProductLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.productLinkId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public TagProductLinkContract apply(Context context) {
        this.innerObject = (TagProductLinkContractInner)((Object)this.serviceManager.serviceClient().getTagProductLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.productLinkId, this.innerModel(), context).getValue());
        return this;
    }

    TagProductLinkContractImpl(TagProductLinkContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.tagId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tags");
        this.productLinkId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "productLinks");
    }

    @Override
    public TagProductLinkContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getTagProductLinks().getWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.productLinkId, Context.NONE).getValue();
        return this;
    }

    @Override
    public TagProductLinkContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTagProductLinks().getWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.productLinkId, context).getValue();
        return this;
    }

    @Override
    public TagProductLinkContractImpl withProductId(String productId) {
        this.innerModel().withProductId(productId);
        return this;
    }
}

