/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.TenantAccessGitsClient;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.AccessIdName;
import reactor.core.publisher.Mono;

public final class TenantAccessGitsClientImpl
implements TenantAccessGitsClient {
    private final TenantAccessGitsService service;
    private final ApiManagementClientImpl client;

    TenantAccessGitsClientImpl(ApiManagementClientImpl client) {
        this.service = (TenantAccessGitsService)RestProxy.create(TenantAccessGitsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> regeneratePrimaryKeyWithResponseAsync(String resourceGroupName, String serviceName, AccessIdName accessName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (accessName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regeneratePrimaryKey(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), accessName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> regeneratePrimaryKeyWithResponseAsync(String resourceGroupName, String serviceName, AccessIdName accessName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (accessName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regeneratePrimaryKey(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), accessName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> regeneratePrimaryKeyAsync(String resourceGroupName, String serviceName, AccessIdName accessName) {
        return this.regeneratePrimaryKeyWithResponseAsync(resourceGroupName, serviceName, accessName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> regeneratePrimaryKeyWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName, Context context) {
        return (Response)this.regeneratePrimaryKeyWithResponseAsync(resourceGroupName, serviceName, accessName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void regeneratePrimaryKey(String resourceGroupName, String serviceName, AccessIdName accessName) {
        this.regeneratePrimaryKeyWithResponse(resourceGroupName, serviceName, accessName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> regenerateSecondaryKeyWithResponseAsync(String resourceGroupName, String serviceName, AccessIdName accessName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (accessName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regenerateSecondaryKey(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), accessName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> regenerateSecondaryKeyWithResponseAsync(String resourceGroupName, String serviceName, AccessIdName accessName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (accessName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regenerateSecondaryKey(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), accessName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> regenerateSecondaryKeyAsync(String resourceGroupName, String serviceName, AccessIdName accessName) {
        return this.regenerateSecondaryKeyWithResponseAsync(resourceGroupName, serviceName, accessName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> regenerateSecondaryKeyWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName, Context context) {
        return (Response)this.regenerateSecondaryKeyWithResponseAsync(resourceGroupName, serviceName, accessName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void regenerateSecondaryKey(String resourceGroupName, String serviceName, AccessIdName accessName) {
        this.regenerateSecondaryKeyWithResponse(resourceGroupName, serviceName, accessName, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientT")
    public static interface TenantAccessGitsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{accessName}/git/regeneratePrimaryKey")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> regeneratePrimaryKey(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="accessName") AccessIdName var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{accessName}/git/regenerateSecondaryKey")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> regenerateSecondaryKey(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="accessName") AccessIdName var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

