/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.TenantSettingsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TenantSettingsContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TenantSettingsContractImpl;
import com.azure.resourcemanager.apimanagement.models.SettingsTypeName;
import com.azure.resourcemanager.apimanagement.models.TenantSettings;
import com.azure.resourcemanager.apimanagement.models.TenantSettingsContract;
import com.azure.resourcemanager.apimanagement.models.TenantSettingsGetResponse;

public final class TenantSettingsImpl
implements TenantSettings {
    private static final ClientLogger LOGGER = new ClientLogger(TenantSettingsImpl.class);
    private final TenantSettingsClient innerClient;
    private final ApiManagementManager serviceManager;

    public TenantSettingsImpl(TenantSettingsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TenantSettingsContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<TenantSettingsContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TenantSettingsContractImpl((TenantSettingsContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TenantSettingsContract> listByService(String resourceGroupName, String serviceName, String filter, Context context) {
        PagedIterable<TenantSettingsContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TenantSettingsContractImpl((TenantSettingsContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<TenantSettingsContract> getWithResponse(String resourceGroupName, String serviceName, SettingsTypeName settingsType, Context context) {
        TenantSettingsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, settingsType, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TenantSettingsContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TenantSettingsContract get(String resourceGroupName, String serviceName, SettingsTypeName settingsType) {
        TenantSettingsContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, settingsType);
        if (inner != null) {
            return new TenantSettingsContractImpl(inner, this.manager());
        }
        return null;
    }

    private TenantSettingsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

