/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.GroupContractProperties;
import com.azure.resourcemanager.apimanagement.fluent.models.UserContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.UserIdentityContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.UserIdentityContractImpl;
import com.azure.resourcemanager.apimanagement.models.AppType;
import com.azure.resourcemanager.apimanagement.models.Confirmation;
import com.azure.resourcemanager.apimanagement.models.GenerateSsoUrlResult;
import com.azure.resourcemanager.apimanagement.models.UserContract;
import com.azure.resourcemanager.apimanagement.models.UserCreateParameters;
import com.azure.resourcemanager.apimanagement.models.UserIdentityContract;
import com.azure.resourcemanager.apimanagement.models.UserState;
import com.azure.resourcemanager.apimanagement.models.UserTokenParameters;
import com.azure.resourcemanager.apimanagement.models.UserTokenResult;
import com.azure.resourcemanager.apimanagement.models.UserUpdateParameters;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class UserContractImpl
implements UserContract,
UserContract.Definition,
UserContract.Update {
    private UserContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String userId;
    private Boolean createNotify;
    private String createIfMatch;
    private UserCreateParameters createParameters;
    private String updateIfMatch;
    private UserUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String firstName() {
        return this.innerModel().firstName();
    }

    @Override
    public String lastName() {
        return this.innerModel().lastName();
    }

    @Override
    public String email() {
        return this.innerModel().email();
    }

    @Override
    public OffsetDateTime registrationDate() {
        return this.innerModel().registrationDate();
    }

    @Override
    public List<GroupContractProperties> groups() {
        List<GroupContractProperties> inner = this.innerModel().groups();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public UserState state() {
        return this.innerModel().state();
    }

    @Override
    public String note() {
        return this.innerModel().note();
    }

    @Override
    public List<UserIdentityContract> identities() {
        List<UserIdentityContractInner> inner = this.innerModel().identities();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new UserIdentityContractImpl((UserIdentityContractInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public UserContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public UserContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public UserContract create() {
        this.innerObject = this.serviceManager.serviceClient().getUsers().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.userId, this.createParameters, this.createNotify, this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public UserContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getUsers().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.userId, this.createParameters, this.createNotify, this.createIfMatch, context).getValue();
        return this;
    }

    UserContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new UserContractInner();
        this.serviceManager = serviceManager;
        this.userId = name;
        this.createNotify = null;
        this.createIfMatch = null;
        this.createParameters = new UserCreateParameters();
    }

    @Override
    public UserContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new UserUpdateParameters();
        return this;
    }

    @Override
    public UserContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getUsers().updateWithResponse(this.resourceGroupName, this.serviceName, this.userId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public UserContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getUsers().updateWithResponse(this.resourceGroupName, this.serviceName, this.userId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    UserContractImpl(UserContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.userId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "users");
    }

    @Override
    public UserContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getUsers().getWithResponse(this.resourceGroupName, this.serviceName, this.userId, Context.NONE).getValue();
        return this;
    }

    @Override
    public UserContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getUsers().getWithResponse(this.resourceGroupName, this.serviceName, this.userId, context).getValue();
        return this;
    }

    @Override
    public Response<GenerateSsoUrlResult> generateSsoUrlWithResponse(Context context) {
        return this.serviceManager.users().generateSsoUrlWithResponse(this.resourceGroupName, this.serviceName, this.userId, context);
    }

    @Override
    public GenerateSsoUrlResult generateSsoUrl() {
        return this.serviceManager.users().generateSsoUrl(this.resourceGroupName, this.serviceName, this.userId);
    }

    @Override
    public Response<UserTokenResult> getSharedAccessTokenWithResponse(UserTokenParameters parameters, Context context) {
        return this.serviceManager.users().getSharedAccessTokenWithResponse(this.resourceGroupName, this.serviceName, this.userId, parameters, context);
    }

    @Override
    public UserTokenResult getSharedAccessToken(UserTokenParameters parameters) {
        return this.serviceManager.users().getSharedAccessToken(this.resourceGroupName, this.serviceName, this.userId, parameters);
    }

    @Override
    public UserContractImpl withEmail(String email) {
        if (this.isInCreateMode()) {
            this.createParameters.withEmail(email);
            return this;
        }
        this.updateParameters.withEmail(email);
        return this;
    }

    @Override
    public UserContractImpl withFirstName(String firstName) {
        if (this.isInCreateMode()) {
            this.createParameters.withFirstName(firstName);
            return this;
        }
        this.updateParameters.withFirstName(firstName);
        return this;
    }

    @Override
    public UserContractImpl withLastName(String lastName) {
        if (this.isInCreateMode()) {
            this.createParameters.withLastName(lastName);
            return this;
        }
        this.updateParameters.withLastName(lastName);
        return this;
    }

    @Override
    public UserContractImpl withPassword(String password) {
        if (this.isInCreateMode()) {
            this.createParameters.withPassword(password);
            return this;
        }
        this.updateParameters.withPassword(password);
        return this;
    }

    @Override
    public UserContractImpl withAppType(AppType appType) {
        this.createParameters.withAppType(appType);
        return this;
    }

    @Override
    public UserContractImpl withConfirmation(Confirmation confirmation) {
        this.createParameters.withConfirmation(confirmation);
        return this;
    }

    @Override
    public UserContractImpl withState(UserState state) {
        if (this.isInCreateMode()) {
            this.createParameters.withState(state);
            return this;
        }
        this.updateParameters.withState(state);
        return this;
    }

    @Override
    public UserContractImpl withNote(String note) {
        if (this.isInCreateMode()) {
            this.createParameters.withNote(note);
            return this;
        }
        this.updateParameters.withNote(note);
        return this;
    }

    @Override
    public UserContractImpl withIdentities(List<UserIdentityContractInner> identities) {
        if (this.isInCreateMode()) {
            this.createParameters.withIdentities(identities);
            return this;
        }
        this.updateParameters.withIdentities(identities);
        return this;
    }

    @Override
    public UserContractImpl withNotify(Boolean notify) {
        this.createNotify = notify;
        return this;
    }

    @Override
    public UserContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

