/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.UserIdentitiesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.UserIdentityContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.UserIdentityContractImpl;
import com.azure.resourcemanager.apimanagement.models.UserIdentities;
import com.azure.resourcemanager.apimanagement.models.UserIdentityContract;

public final class UserIdentitiesImpl
implements UserIdentities {
    private static final ClientLogger LOGGER = new ClientLogger(UserIdentitiesImpl.class);
    private final UserIdentitiesClient innerClient;
    private final ApiManagementManager serviceManager;

    public UserIdentitiesImpl(UserIdentitiesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<UserIdentityContract> list(String resourceGroupName, String serviceName, String userId) {
        PagedIterable<UserIdentityContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, userId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UserIdentityContractImpl((UserIdentityContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<UserIdentityContract> list(String resourceGroupName, String serviceName, String userId, Context context) {
        PagedIterable<UserIdentityContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, userId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UserIdentityContractImpl((UserIdentityContractInner)inner1, this.manager()));
    }

    private UserIdentitiesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

