/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceApiVersionSetsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiVersionSetContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiVersionSetContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetContract;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiVersionSets;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiVersionSetsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiVersionSetsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiVersionSetsGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiVersionSetsUpdateResponse;

public final class WorkspaceApiVersionSetsImpl
implements WorkspaceApiVersionSets {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceApiVersionSetsImpl.class);
    private final WorkspaceApiVersionSetsClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceApiVersionSetsImpl(WorkspaceApiVersionSetsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApiVersionSetContract> listByService(String resourceGroupName, String serviceName, String workspaceId) {
        PagedIterable<ApiVersionSetContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiVersionSetContractImpl((ApiVersionSetContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiVersionSetContract> listByService(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ApiVersionSetContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiVersionSetContractImpl((ApiVersionSetContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspaceApiVersionSetsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String versionSetId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, versionSetId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String versionSetId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, versionSetId);
    }

    @Override
    public Response<ApiVersionSetContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String versionSetId, Context context) {
        WorkspaceApiVersionSetsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, versionSetId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiVersionSetContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiVersionSetContract get(String resourceGroupName, String serviceName, String workspaceId, String versionSetId) {
        ApiVersionSetContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, versionSetId);
        if (inner != null) {
            return new ApiVersionSetContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApiVersionSetContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String versionSetId, ApiVersionSetContractInner parameters, String ifMatch, Context context) {
        WorkspaceApiVersionSetsCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, versionSetId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiVersionSetContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiVersionSetContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String versionSetId, ApiVersionSetContractInner parameters) {
        ApiVersionSetContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, versionSetId, parameters);
        if (inner != null) {
            return new ApiVersionSetContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApiVersionSetContract> updateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String versionSetId, String ifMatch, ApiVersionSetUpdateParameters parameters, Context context) {
        WorkspaceApiVersionSetsUpdateResponse inner = this.serviceClient().updateWithResponse(resourceGroupName, serviceName, workspaceId, versionSetId, ifMatch, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiVersionSetContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiVersionSetContract update(String resourceGroupName, String serviceName, String workspaceId, String versionSetId, String ifMatch, ApiVersionSetUpdateParameters parameters) {
        ApiVersionSetContractInner inner = this.serviceClient().update(resourceGroupName, serviceName, workspaceId, versionSetId, ifMatch, parameters);
        if (inner != null) {
            return new ApiVersionSetContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String versionSetId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, versionSetId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String versionSetId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, versionSetId, ifMatch);
    }

    private WorkspaceApiVersionSetsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

