/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceCertificatesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.CertificateContractInner;
import com.azure.resourcemanager.apimanagement.implementation.CertificateContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.CertificateContract;
import com.azure.resourcemanager.apimanagement.models.CertificateCreateOrUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.WorkspaceCertificates;
import com.azure.resourcemanager.apimanagement.models.WorkspaceCertificatesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceCertificatesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceCertificatesGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceCertificatesRefreshSecretResponse;

public final class WorkspaceCertificatesImpl
implements WorkspaceCertificates {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceCertificatesImpl.class);
    private final WorkspaceCertificatesClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceCertificatesImpl(WorkspaceCertificatesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<CertificateContract> listByWorkspace(String resourceGroupName, String serviceName, String workspaceId) {
        PagedIterable<CertificateContractInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateContractImpl((CertificateContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CertificateContract> listByWorkspace(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, Boolean isKeyVaultRefreshFailed, Context context) {
        PagedIterable<CertificateContractInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, serviceName, workspaceId, filter, top, skip, isKeyVaultRefreshFailed, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateContractImpl((CertificateContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspaceCertificatesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String certificateId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, certificateId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String certificateId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, certificateId);
    }

    @Override
    public Response<CertificateContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String certificateId, Context context) {
        WorkspaceCertificatesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, certificateId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CertificateContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CertificateContract get(String resourceGroupName, String serviceName, String workspaceId, String certificateId) {
        CertificateContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, certificateId);
        if (inner != null) {
            return new CertificateContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<CertificateContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String certificateId, CertificateCreateOrUpdateParameters parameters, String ifMatch, Context context) {
        WorkspaceCertificatesCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, certificateId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CertificateContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CertificateContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String certificateId, CertificateCreateOrUpdateParameters parameters) {
        CertificateContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, certificateId, parameters);
        if (inner != null) {
            return new CertificateContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String certificateId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, certificateId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String certificateId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, certificateId, ifMatch);
    }

    @Override
    public Response<CertificateContract> refreshSecretWithResponse(String resourceGroupName, String serviceName, String workspaceId, String certificateId, Context context) {
        WorkspaceCertificatesRefreshSecretResponse inner = this.serviceClient().refreshSecretWithResponse(resourceGroupName, serviceName, workspaceId, certificateId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CertificateContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CertificateContract refreshSecret(String resourceGroupName, String serviceName, String workspaceId, String certificateId) {
        CertificateContractInner inner = this.serviceClient().refreshSecret(resourceGroupName, serviceName, workspaceId, certificateId);
        if (inner != null) {
            return new CertificateContractImpl(inner, this.manager());
        }
        return null;
    }

    private WorkspaceCertificatesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

