/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceDiagnosticsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.DiagnosticContractInner;
import com.azure.resourcemanager.apimanagement.implementation.DiagnosticContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.DiagnosticContract;
import com.azure.resourcemanager.apimanagement.models.DiagnosticUpdateContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceDiagnostics;
import com.azure.resourcemanager.apimanagement.models.WorkspaceDiagnosticsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceDiagnosticsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceDiagnosticsGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceDiagnosticsUpdateResponse;

public final class WorkspaceDiagnosticsImpl
implements WorkspaceDiagnostics {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceDiagnosticsImpl.class);
    private final WorkspaceDiagnosticsClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceDiagnosticsImpl(WorkspaceDiagnosticsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DiagnosticContract> listByWorkspace(String resourceGroupName, String serviceName, String workspaceId) {
        PagedIterable<DiagnosticContractInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticContractImpl((DiagnosticContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DiagnosticContract> listByWorkspace(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<DiagnosticContractInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, serviceName, workspaceId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticContractImpl((DiagnosticContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspaceDiagnosticsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, diagnosticId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, diagnosticId);
    }

    @Override
    public Response<DiagnosticContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, Context context) {
        WorkspaceDiagnosticsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, diagnosticId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiagnosticContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DiagnosticContract get(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId) {
        DiagnosticContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, diagnosticId);
        if (inner != null) {
            return new DiagnosticContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DiagnosticContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, DiagnosticContractInner parameters, String ifMatch, Context context) {
        WorkspaceDiagnosticsCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, diagnosticId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiagnosticContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DiagnosticContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, DiagnosticContractInner parameters) {
        DiagnosticContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, diagnosticId, parameters);
        if (inner != null) {
            return new DiagnosticContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DiagnosticContract> updateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch, DiagnosticUpdateContract parameters, Context context) {
        WorkspaceDiagnosticsUpdateResponse inner = this.serviceClient().updateWithResponse(resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiagnosticContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DiagnosticContract update(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch, DiagnosticUpdateContract parameters) {
        DiagnosticContractInner inner = this.serviceClient().update(resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, parameters);
        if (inner != null) {
            return new DiagnosticContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch);
    }

    private WorkspaceDiagnosticsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

