/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceNotificationRecipientEmailsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.RecipientEmailCollectionInner;
import com.azure.resourcemanager.apimanagement.fluent.models.RecipientEmailContractInner;
import com.azure.resourcemanager.apimanagement.implementation.RecipientEmailCollectionImpl;
import com.azure.resourcemanager.apimanagement.implementation.RecipientEmailContractImpl;
import com.azure.resourcemanager.apimanagement.models.NotificationName;
import com.azure.resourcemanager.apimanagement.models.RecipientEmailCollection;
import com.azure.resourcemanager.apimanagement.models.RecipientEmailContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceNotificationRecipientEmails;

public final class WorkspaceNotificationRecipientEmailsImpl
implements WorkspaceNotificationRecipientEmails {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceNotificationRecipientEmailsImpl.class);
    private final WorkspaceNotificationRecipientEmailsClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceNotificationRecipientEmailsImpl(WorkspaceNotificationRecipientEmailsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<RecipientEmailCollection> listByNotificationWithResponse(String resourceGroupName, String serviceName, String workspaceId, NotificationName notificationName, Context context) {
        Response<RecipientEmailCollectionInner> inner = this.serviceClient().listByNotificationWithResponse(resourceGroupName, serviceName, workspaceId, notificationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RecipientEmailCollectionImpl((RecipientEmailCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RecipientEmailCollection listByNotification(String resourceGroupName, String serviceName, String workspaceId, NotificationName notificationName) {
        RecipientEmailCollectionInner inner = this.serviceClient().listByNotification(resourceGroupName, serviceName, workspaceId, notificationName);
        if (inner != null) {
            return new RecipientEmailCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Boolean> checkEntityExistsWithResponse(String resourceGroupName, String serviceName, String workspaceId, NotificationName notificationName, String email, Context context) {
        return this.serviceClient().checkEntityExistsWithResponse(resourceGroupName, serviceName, workspaceId, notificationName, email, context);
    }

    @Override
    public boolean checkEntityExists(String resourceGroupName, String serviceName, String workspaceId, NotificationName notificationName, String email) {
        return this.serviceClient().checkEntityExists(resourceGroupName, serviceName, workspaceId, notificationName, email);
    }

    @Override
    public Response<RecipientEmailContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, NotificationName notificationName, String email, Context context) {
        Response<RecipientEmailContractInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, notificationName, email, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RecipientEmailContractImpl((RecipientEmailContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public RecipientEmailContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, NotificationName notificationName, String email) {
        RecipientEmailContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, notificationName, email);
        if (inner != null) {
            return new RecipientEmailContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, NotificationName notificationName, String email, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, notificationName, email, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, NotificationName notificationName, String email) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, notificationName, email);
    }

    private WorkspaceNotificationRecipientEmailsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

