/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspacePolicyFragmentsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyFragmentContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.ResourceCollectionInner;
import com.azure.resourcemanager.apimanagement.implementation.PolicyFragmentContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceCollectionImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentContentFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentContract;
import com.azure.resourcemanager.apimanagement.models.ResourceCollection;
import com.azure.resourcemanager.apimanagement.models.WorkspacePolicyFragments;
import com.azure.resourcemanager.apimanagement.models.WorkspacePolicyFragmentsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspacePolicyFragmentsGetResponse;

public final class WorkspacePolicyFragmentsImpl
implements WorkspacePolicyFragments {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspacePolicyFragmentsImpl.class);
    private final WorkspacePolicyFragmentsClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspacePolicyFragmentsImpl(WorkspacePolicyFragmentsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PolicyFragmentContract> listByService(String resourceGroupName, String serviceName, String workspaceId) {
        PagedIterable<PolicyFragmentContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyFragmentContractImpl((PolicyFragmentContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PolicyFragmentContract> listByService(String resourceGroupName, String serviceName, String workspaceId, String filter, String orderby, Integer top, Integer skip, Context context) {
        PagedIterable<PolicyFragmentContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId, filter, orderby, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyFragmentContractImpl((PolicyFragmentContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspacePolicyFragmentsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String id, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, id, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String id) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, id);
    }

    @Override
    public Response<PolicyFragmentContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String id, PolicyFragmentContentFormat format, Context context) {
        WorkspacePolicyFragmentsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, id, format, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyFragmentContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyFragmentContract get(String resourceGroupName, String serviceName, String workspaceId, String id) {
        PolicyFragmentContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, id);
        if (inner != null) {
            return new PolicyFragmentContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PolicyFragmentContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String id, PolicyFragmentContractInner parameters) {
        PolicyFragmentContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, id, parameters);
        if (inner != null) {
            return new PolicyFragmentContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PolicyFragmentContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String id, PolicyFragmentContractInner parameters, String ifMatch, Context context) {
        PolicyFragmentContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, id, parameters, ifMatch, context);
        if (inner != null) {
            return new PolicyFragmentContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String id, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, id, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String id, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, id, ifMatch);
    }

    @Override
    public Response<ResourceCollection> listReferencesWithResponse(String resourceGroupName, String serviceName, String workspaceId, String id, Integer top, Integer skip, Context context) {
        Response<ResourceCollectionInner> inner = this.serviceClient().listReferencesWithResponse(resourceGroupName, serviceName, workspaceId, id, top, skip, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ResourceCollectionImpl((ResourceCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ResourceCollection listReferences(String resourceGroupName, String serviceName, String workspaceId, String id) {
        ResourceCollectionInner inner = this.serviceClient().listReferences(resourceGroupName, serviceName, workspaceId, id);
        if (inner != null) {
            return new ResourceCollectionImpl(inner, this.manager());
        }
        return null;
    }

    private WorkspacePolicyFragmentsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

