/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceProductApiLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductApiLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ProductApiLinkContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinkContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductApiLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductApiLinksGetResponse;

public final class WorkspaceProductApiLinksImpl
implements WorkspaceProductApiLinks {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceProductApiLinksImpl.class);
    private final WorkspaceProductApiLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceProductApiLinksImpl(WorkspaceProductApiLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ProductApiLinkContract> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String productId) {
        PagedIterable<ProductApiLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductApiLinkContractImpl((ProductApiLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProductApiLinkContract> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ProductApiLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductApiLinkContractImpl((ProductApiLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ProductApiLinkContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, Context context) {
        WorkspaceProductApiLinksGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProductApiLinkContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ProductApiLinkContract get(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId) {
        ProductApiLinkContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, productId, apiLinkId);
        if (inner != null) {
            return new ProductApiLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ProductApiLinkContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, ProductApiLinkContractInner parameters, Context context) {
        Response<ProductApiLinkContractInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProductApiLinkContractImpl((ProductApiLinkContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProductApiLinkContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, ProductApiLinkContractInner parameters) {
        ProductApiLinkContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, parameters);
        if (inner != null) {
            return new ProductApiLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, productId, apiLinkId);
    }

    private WorkspaceProductApiLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

