/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceProductGroupLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductGroupLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ProductGroupLinkContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ProductGroupLinkContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductGroupLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductGroupLinksGetResponse;

public final class WorkspaceProductGroupLinksImpl
implements WorkspaceProductGroupLinks {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceProductGroupLinksImpl.class);
    private final WorkspaceProductGroupLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceProductGroupLinksImpl(WorkspaceProductGroupLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ProductGroupLinkContract> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String productId) {
        PagedIterable<ProductGroupLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductGroupLinkContractImpl((ProductGroupLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProductGroupLinkContract> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ProductGroupLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductGroupLinkContractImpl((ProductGroupLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ProductGroupLinkContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, String groupLinkId, Context context) {
        WorkspaceProductGroupLinksGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, productId, groupLinkId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProductGroupLinkContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ProductGroupLinkContract get(String resourceGroupName, String serviceName, String workspaceId, String productId, String groupLinkId) {
        ProductGroupLinkContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, productId, groupLinkId);
        if (inner != null) {
            return new ProductGroupLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ProductGroupLinkContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, String groupLinkId, ProductGroupLinkContractInner parameters, Context context) {
        Response<ProductGroupLinkContractInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, productId, groupLinkId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProductGroupLinkContractImpl((ProductGroupLinkContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProductGroupLinkContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String productId, String groupLinkId, ProductGroupLinkContractInner parameters) {
        ProductGroupLinkContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, productId, groupLinkId, parameters);
        if (inner != null) {
            return new ProductGroupLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, String groupLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, productId, groupLinkId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String productId, String groupLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, productId, groupLinkId);
    }

    private WorkspaceProductGroupLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

