/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceTagProductLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagProductLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TagProductLinkContractImpl;
import com.azure.resourcemanager.apimanagement.models.TagProductLinkContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagProductLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagProductLinksGetResponse;

public final class WorkspaceTagProductLinksImpl
implements WorkspaceTagProductLinks {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceTagProductLinksImpl.class);
    private final WorkspaceTagProductLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceTagProductLinksImpl(WorkspaceTagProductLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TagProductLinkContract> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String tagId) {
        PagedIterable<TagProductLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, tagId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagProductLinkContractImpl((TagProductLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagProductLinkContract> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String tagId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagProductLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, tagId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagProductLinkContractImpl((TagProductLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<TagProductLinkContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, String productLinkId, Context context) {
        WorkspaceTagProductLinksGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, tagId, productLinkId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagProductLinkContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagProductLinkContract get(String resourceGroupName, String serviceName, String workspaceId, String tagId, String productLinkId) {
        TagProductLinkContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, tagId, productLinkId);
        if (inner != null) {
            return new TagProductLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TagProductLinkContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, String productLinkId, TagProductLinkContractInner parameters, Context context) {
        Response<TagProductLinkContractInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, tagId, productLinkId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagProductLinkContractImpl((TagProductLinkContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TagProductLinkContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String tagId, String productLinkId, TagProductLinkContractInner parameters) {
        TagProductLinkContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, tagId, productLinkId, parameters);
        if (inner != null) {
            return new TagProductLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, String productLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, tagId, productLinkId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String tagId, String productLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, tagId, productLinkId);
    }

    private WorkspaceTagProductLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

