/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceTagsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TagContractImpl;
import com.azure.resourcemanager.apimanagement.models.TagContract;
import com.azure.resourcemanager.apimanagement.models.TagCreateUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTags;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagsGetEntityStateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagsGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagsUpdateResponse;

public final class WorkspaceTagsImpl
implements WorkspaceTags {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceTagsImpl.class);
    private final WorkspaceTagsClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceTagsImpl(WorkspaceTagsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TagContract> listByService(String resourceGroupName, String serviceName, String workspaceId) {
        PagedIterable<TagContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagContractImpl((TagContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagContract> listByService(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, String scope, Context context) {
        PagedIterable<TagContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId, filter, top, skip, scope, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagContractImpl((TagContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspaceTagsGetEntityStateResponse getEntityStateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, Context context) {
        return this.serviceClient().getEntityStateWithResponse(resourceGroupName, serviceName, workspaceId, tagId, context);
    }

    @Override
    public void getEntityState(String resourceGroupName, String serviceName, String workspaceId, String tagId) {
        this.serviceClient().getEntityState(resourceGroupName, serviceName, workspaceId, tagId);
    }

    @Override
    public Response<TagContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, Context context) {
        WorkspaceTagsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, tagId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagContract get(String resourceGroupName, String serviceName, String workspaceId, String tagId) {
        TagContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, tagId);
        if (inner != null) {
            return new TagContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TagContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, TagCreateUpdateParameters parameters, String ifMatch, Context context) {
        WorkspaceTagsCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, tagId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String tagId, TagCreateUpdateParameters parameters) {
        TagContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, tagId, parameters);
        if (inner != null) {
            return new TagContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TagContract> updateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, String ifMatch, TagCreateUpdateParameters parameters, Context context) {
        WorkspaceTagsUpdateResponse inner = this.serviceClient().updateWithResponse(resourceGroupName, serviceName, workspaceId, tagId, ifMatch, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagContract update(String resourceGroupName, String serviceName, String workspaceId, String tagId, String ifMatch, TagCreateUpdateParameters parameters) {
        TagContractInner inner = this.serviceClient().update(resourceGroupName, serviceName, workspaceId, tagId, ifMatch, parameters);
        if (inner != null) {
            return new TagContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, tagId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String tagId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, tagId, ifMatch);
    }

    private WorkspaceTagsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

