/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiContactInformation;
import com.azure.resourcemanager.apimanagement.models.ApiCreateOrUpdatePropertiesWsdlSelector;
import com.azure.resourcemanager.apimanagement.models.ApiLicenseInformation;
import com.azure.resourcemanager.apimanagement.models.ApiType;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetContractDetails;
import com.azure.resourcemanager.apimanagement.models.AuthenticationSettingsContract;
import com.azure.resourcemanager.apimanagement.models.ContentFormat;
import com.azure.resourcemanager.apimanagement.models.Protocol;
import com.azure.resourcemanager.apimanagement.models.SoapApiType;
import com.azure.resourcemanager.apimanagement.models.SubscriptionKeyParameterNamesContract;
import com.azure.resourcemanager.apimanagement.models.TranslateRequiredQueryParametersConduct;
import java.util.List;

public interface ApiContract {
    public String id();

    public String name();

    public String type();

    public String sourceApiId();

    public String displayName();

    public String serviceUrl();

    public String path();

    public List<Protocol> protocols();

    public ApiVersionSetContractDetails apiVersionSet();

    public String provisioningState();

    public String description();

    public AuthenticationSettingsContract authenticationSettings();

    public SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames();

    public ApiType apiType();

    public String apiRevision();

    public String apiVersion();

    public Boolean isCurrent();

    public Boolean isOnline();

    public String apiRevisionDescription();

    public String apiVersionDescription();

    public String apiVersionSetId();

    public Boolean subscriptionRequired();

    public String termsOfServiceUrl();

    public ApiContactInformation contact();

    public ApiLicenseInformation license();

    public String resourceGroupName();

    public ApiContractInner innerModel();

    public Update update();

    public ApiContract refresh();

    public ApiContract refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithLicense {
            public Update withLicense(ApiLicenseInformation var1);
        }

        public static interface WithContact {
            public Update withContact(ApiContactInformation var1);
        }

        public static interface WithTermsOfServiceUrl {
            public Update withTermsOfServiceUrl(String var1);
        }

        public static interface WithSubscriptionRequired {
            public Update withSubscriptionRequired(Boolean var1);
        }

        public static interface WithApiVersionSetId {
            public Update withApiVersionSetId(String var1);
        }

        public static interface WithApiVersionDescription {
            public Update withApiVersionDescription(String var1);
        }

        public static interface WithApiRevisionDescription {
            public Update withApiRevisionDescription(String var1);
        }

        public static interface WithIsCurrent {
            public Update withIsCurrent(Boolean var1);
        }

        public static interface WithApiVersion {
            public Update withApiVersion(String var1);
        }

        public static interface WithApiRevision {
            public Update withApiRevision(String var1);
        }

        public static interface WithApiType {
            public Update withApiType(ApiType var1);
        }

        public static interface WithSubscriptionKeyParameterNames {
            public Update withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract var1);
        }

        public static interface WithAuthenticationSettings {
            public Update withAuthenticationSettings(AuthenticationSettingsContract var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithProtocols {
            public Update withProtocols(List<Protocol> var1);
        }

        public static interface WithPath {
            public Update withPath(String var1);
        }

        public static interface WithServiceUrl {
            public Update withServiceUrl(String var1);
        }

        public static interface WithDisplayName {
            public Update withDisplayName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithDisplayName,
    UpdateStages.WithServiceUrl,
    UpdateStages.WithPath,
    UpdateStages.WithProtocols,
    UpdateStages.WithDescription,
    UpdateStages.WithAuthenticationSettings,
    UpdateStages.WithSubscriptionKeyParameterNames,
    UpdateStages.WithApiType,
    UpdateStages.WithApiRevision,
    UpdateStages.WithApiVersion,
    UpdateStages.WithIsCurrent,
    UpdateStages.WithApiRevisionDescription,
    UpdateStages.WithApiVersionDescription,
    UpdateStages.WithApiVersionSetId,
    UpdateStages.WithSubscriptionRequired,
    UpdateStages.WithTermsOfServiceUrl,
    UpdateStages.WithContact,
    UpdateStages.WithLicense,
    UpdateStages.WithIfMatch {
        public ApiContract apply();

        public ApiContract apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithLicense {
            public WithCreate withLicense(ApiLicenseInformation var1);
        }

        public static interface WithContact {
            public WithCreate withContact(ApiContactInformation var1);
        }

        public static interface WithTermsOfServiceUrl {
            public WithCreate withTermsOfServiceUrl(String var1);
        }

        public static interface WithSubscriptionRequired {
            public WithCreate withSubscriptionRequired(Boolean var1);
        }

        public static interface WithApiVersionSetId {
            public WithCreate withApiVersionSetId(String var1);
        }

        public static interface WithApiVersionDescription {
            public WithCreate withApiVersionDescription(String var1);
        }

        public static interface WithApiRevisionDescription {
            public WithCreate withApiRevisionDescription(String var1);
        }

        public static interface WithIsCurrent {
            public WithCreate withIsCurrent(Boolean var1);
        }

        public static interface WithApiVersion {
            public WithCreate withApiVersion(String var1);
        }

        public static interface WithApiRevision {
            public WithCreate withApiRevision(String var1);
        }

        public static interface WithApiType {
            public WithCreate withApiType(ApiType var1);
        }

        public static interface WithSubscriptionKeyParameterNames {
            public WithCreate withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract var1);
        }

        public static interface WithAuthenticationSettings {
            public WithCreate withAuthenticationSettings(AuthenticationSettingsContract var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithApiVersionSet {
            public WithCreate withApiVersionSet(ApiVersionSetContractDetails var1);
        }

        public static interface WithProtocols {
            public WithCreate withProtocols(List<Protocol> var1);
        }

        public static interface WithPath {
            public WithCreate withPath(String var1);
        }

        public static interface WithServiceUrl {
            public WithCreate withServiceUrl(String var1);
        }

        public static interface WithDisplayName {
            public WithCreate withDisplayName(String var1);
        }

        public static interface WithSourceApiId {
            public WithCreate withSourceApiId(String var1);
        }

        public static interface WithTranslateRequiredQueryParametersConduct {
            public WithCreate withTranslateRequiredQueryParametersConduct(TranslateRequiredQueryParametersConduct var1);
        }

        public static interface WithSoapApiType {
            public WithCreate withSoapApiType(SoapApiType var1);
        }

        public static interface WithWsdlSelector {
            public WithCreate withWsdlSelector(ApiCreateOrUpdatePropertiesWsdlSelector var1);
        }

        public static interface WithFormat {
            public WithCreate withFormat(ContentFormat var1);
        }

        public static interface WithValue {
            public WithCreate withValue(String var1);
        }

        public static interface WithCreate
        extends WithValue,
        WithFormat,
        WithWsdlSelector,
        WithSoapApiType,
        WithTranslateRequiredQueryParametersConduct,
        WithSourceApiId,
        WithDisplayName,
        WithServiceUrl,
        WithPath,
        WithProtocols,
        WithApiVersionSet,
        WithDescription,
        WithAuthenticationSettings,
        WithSubscriptionKeyParameterNames,
        WithApiType,
        WithApiRevision,
        WithApiVersion,
        WithIsCurrent,
        WithApiRevisionDescription,
        WithApiVersionDescription,
        WithApiVersionSetId,
        WithSubscriptionRequired,
        WithTermsOfServiceUrl,
        WithContact,
        WithLicense,
        WithIfMatch {
            public ApiContract create();

            public ApiContract create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingService(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

