/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayResourceInner;
import java.io.IOException;
import java.util.List;

public final class ApiManagementGatewayListResult
implements JsonSerializable<ApiManagementGatewayListResult> {
    private List<ApiManagementGatewayResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementGatewayListResult.class);

    public List<ApiManagementGatewayResourceInner> value() {
        return this.value;
    }

    public ApiManagementGatewayListResult withValue(List<ApiManagementGatewayResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ApiManagementGatewayListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ApiManagementGatewayListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementGatewayListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementGatewayListResult)jsonReader.readObject(reader -> {
            ApiManagementGatewayListResult deserializedApiManagementGatewayListResult = new ApiManagementGatewayListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedApiManagementGatewayListResult.value = value = reader.readArray(reader1 -> ApiManagementGatewayResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedApiManagementGatewayListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementGatewayListResult;
        });
    }
}

