/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceResourceInner;
import java.io.IOException;
import java.util.List;

public final class ApiManagementServiceListResult
implements JsonSerializable<ApiManagementServiceListResult> {
    private List<ApiManagementServiceResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServiceListResult.class);

    public List<ApiManagementServiceResourceInner> value() {
        return this.value;
    }

    public ApiManagementServiceListResult withValue(List<ApiManagementServiceResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ApiManagementServiceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ApiManagementServiceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementServiceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementServiceListResult)jsonReader.readObject(reader -> {
            ApiManagementServiceListResult deserializedApiManagementServiceListResult = new ApiManagementServiceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedApiManagementServiceListResult.value = value = reader.readArray(reader1 -> ApiManagementServiceResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedApiManagementServiceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementServiceListResult;
        });
    }
}

