/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceUpdateProperties;
import com.azure.resourcemanager.apimanagement.models.AdditionalLocation;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceIdentity;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceSkuProperties;
import com.azure.resourcemanager.apimanagement.models.ApiVersionConstraint;
import com.azure.resourcemanager.apimanagement.models.ApimResource;
import com.azure.resourcemanager.apimanagement.models.CertificateConfiguration;
import com.azure.resourcemanager.apimanagement.models.ConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.DeveloperPortalStatus;
import com.azure.resourcemanager.apimanagement.models.HostnameConfiguration;
import com.azure.resourcemanager.apimanagement.models.LegacyPortalStatus;
import com.azure.resourcemanager.apimanagement.models.NatGatewayState;
import com.azure.resourcemanager.apimanagement.models.PlatformVersion;
import com.azure.resourcemanager.apimanagement.models.PublicNetworkAccess;
import com.azure.resourcemanager.apimanagement.models.RemotePrivateEndpointConnectionWrapper;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkConfiguration;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ApiManagementServiceUpdateParameters
extends ApimResource {
    private ApiManagementServiceUpdateProperties innerProperties;
    private ApiManagementServiceSkuProperties sku;
    private ApiManagementServiceIdentity identity;
    private String etag;
    private List<String> zones;
    private String type;
    private String name;
    private String id;

    private ApiManagementServiceUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public ApiManagementServiceSkuProperties sku() {
        return this.sku;
    }

    public ApiManagementServiceUpdateParameters withSku(ApiManagementServiceSkuProperties sku) {
        this.sku = sku;
        return this;
    }

    public ApiManagementServiceIdentity identity() {
        return this.identity;
    }

    public ApiManagementServiceUpdateParameters withIdentity(ApiManagementServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public List<String> zones() {
        return this.zones;
    }

    public ApiManagementServiceUpdateParameters withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ApiManagementServiceUpdateParameters withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String publisherEmail() {
        return this.innerProperties() == null ? null : this.innerProperties().publisherEmail();
    }

    public ApiManagementServiceUpdateParameters withPublisherEmail(String publisherEmail) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withPublisherEmail(publisherEmail);
        return this;
    }

    public String publisherName() {
        return this.innerProperties() == null ? null : this.innerProperties().publisherName();
    }

    public ApiManagementServiceUpdateParameters withPublisherName(String publisherName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withPublisherName(publisherName);
        return this;
    }

    public String notificationSenderEmail() {
        return this.innerProperties() == null ? null : this.innerProperties().notificationSenderEmail();
    }

    public ApiManagementServiceUpdateParameters withNotificationSenderEmail(String notificationSenderEmail) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withNotificationSenderEmail(notificationSenderEmail);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String targetProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().targetProvisioningState();
    }

    public OffsetDateTime createdAtUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAtUtc();
    }

    public String gatewayUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayUrl();
    }

    public String gatewayRegionalUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayRegionalUrl();
    }

    public String portalUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().portalUrl();
    }

    public String managementApiUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().managementApiUrl();
    }

    public String scmUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().scmUrl();
    }

    public String developerPortalUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().developerPortalUrl();
    }

    public List<HostnameConfiguration> hostnameConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().hostnameConfigurations();
    }

    public ApiManagementServiceUpdateParameters withHostnameConfigurations(List<HostnameConfiguration> hostnameConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withHostnameConfigurations((List)hostnameConfigurations);
        return this;
    }

    public List<String> publicIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddresses();
    }

    public List<String> privateIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().privateIpAddresses();
    }

    public String publicIpAddressId() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddressId();
    }

    public ApiManagementServiceUpdateParameters withPublicIpAddressId(String publicIpAddressId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withPublicIpAddressId(publicIpAddressId);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ApiManagementServiceUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public ConfigurationApi configurationApi() {
        return this.innerProperties() == null ? null : this.innerProperties().configurationApi();
    }

    public ApiManagementServiceUpdateParameters withConfigurationApi(ConfigurationApi configurationApi) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withConfigurationApi(configurationApi);
        return this;
    }

    public VirtualNetworkConfiguration virtualNetworkConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkConfiguration();
    }

    public ApiManagementServiceUpdateParameters withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withVirtualNetworkConfiguration(virtualNetworkConfiguration);
        return this;
    }

    public List<AdditionalLocation> additionalLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalLocations();
    }

    public ApiManagementServiceUpdateParameters withAdditionalLocations(List<AdditionalLocation> additionalLocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withAdditionalLocations((List)additionalLocations);
        return this;
    }

    public Map<String, String> customProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().customProperties();
    }

    public ApiManagementServiceUpdateParameters withCustomProperties(Map<String, String> customProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withCustomProperties((Map)customProperties);
        return this;
    }

    public List<CertificateConfiguration> certificates() {
        return this.innerProperties() == null ? null : this.innerProperties().certificates();
    }

    public ApiManagementServiceUpdateParameters withCertificates(List<CertificateConfiguration> certificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withCertificates((List)certificates);
        return this;
    }

    public Boolean enableClientCertificate() {
        return this.innerProperties() == null ? null : this.innerProperties().enableClientCertificate();
    }

    public ApiManagementServiceUpdateParameters withEnableClientCertificate(Boolean enableClientCertificate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withEnableClientCertificate(enableClientCertificate);
        return this;
    }

    public NatGatewayState natGatewayState() {
        return this.innerProperties() == null ? null : this.innerProperties().natGatewayState();
    }

    public ApiManagementServiceUpdateParameters withNatGatewayState(NatGatewayState natGatewayState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withNatGatewayState(natGatewayState);
        return this;
    }

    public List<String> outboundPublicIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundPublicIpAddresses();
    }

    public Boolean disableGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().disableGateway();
    }

    public ApiManagementServiceUpdateParameters withDisableGateway(Boolean disableGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withDisableGateway(disableGateway);
        return this;
    }

    public VirtualNetworkType virtualNetworkType() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkType();
    }

    public ApiManagementServiceUpdateParameters withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    public ApiVersionConstraint apiVersionConstraint() {
        return this.innerProperties() == null ? null : this.innerProperties().apiVersionConstraint();
    }

    public ApiManagementServiceUpdateParameters withApiVersionConstraint(ApiVersionConstraint apiVersionConstraint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withApiVersionConstraint(apiVersionConstraint);
        return this;
    }

    public Boolean restore() {
        return this.innerProperties() == null ? null : this.innerProperties().restore();
    }

    public ApiManagementServiceUpdateParameters withRestore(Boolean restore) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withRestore(restore);
        return this;
    }

    public List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public ApiManagementServiceUpdateParameters withPrivateEndpointConnections(List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withPrivateEndpointConnections((List)privateEndpointConnections);
        return this;
    }

    public PlatformVersion platformVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().platformVersion();
    }

    public LegacyPortalStatus legacyPortalStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().legacyPortalStatus();
    }

    public ApiManagementServiceUpdateParameters withLegacyPortalStatus(LegacyPortalStatus legacyPortalStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withLegacyPortalStatus(legacyPortalStatus);
        return this;
    }

    public DeveloperPortalStatus developerPortalStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().developerPortalStatus();
    }

    public ApiManagementServiceUpdateParameters withDeveloperPortalStatus(DeveloperPortalStatus developerPortalStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceUpdateProperties();
        }
        this.innerProperties().withDeveloperPortalStatus(developerPortalStatus);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementServiceUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementServiceUpdateParameters)((Object)jsonReader.readObject(reader -> {
            ApiManagementServiceUpdateParameters deserializedApiManagementServiceUpdateParameters = new ApiManagementServiceUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateParameters.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApiManagementServiceUpdateParameters.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateParameters.innerProperties = ApiManagementServiceUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateParameters.sku = ApiManagementServiceSkuProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateParameters.identity = ApiManagementServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateParameters.etag = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedApiManagementServiceUpdateParameters.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementServiceUpdateParameters;
        }));
    }
}

