/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiRevisionContractInner;
import java.io.IOException;
import java.util.List;

public final class ApiRevisionCollection
implements JsonSerializable<ApiRevisionCollection> {
    private List<ApiRevisionContractInner> value;
    private Long count;
    private String nextLink;

    public List<ApiRevisionContractInner> value() {
        return this.value;
    }

    public Long count() {
        return this.count;
    }

    public ApiRevisionCollection withCount(Long count) {
        this.count = count;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", (Number)this.count);
        return jsonWriter.writeEndObject();
    }

    public static ApiRevisionCollection fromJson(JsonReader jsonReader) throws IOException {
        return (ApiRevisionCollection)jsonReader.readObject(reader -> {
            ApiRevisionCollection deserializedApiRevisionCollection = new ApiRevisionCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedApiRevisionCollection.value = value = reader.readArray(reader1 -> ApiRevisionContractInner.fromJson(reader1));
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedApiRevisionCollection.count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedApiRevisionCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiRevisionCollection;
        });
    }
}

