/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationServerContractInner;
import com.azure.resourcemanager.apimanagement.models.AuthorizationMethod;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerSecretsContract;
import com.azure.resourcemanager.apimanagement.models.BearerTokenSendingMethod;
import com.azure.resourcemanager.apimanagement.models.ClientAuthenticationMethod;
import com.azure.resourcemanager.apimanagement.models.GrantType;
import com.azure.resourcemanager.apimanagement.models.TokenBodyParameterContract;
import java.util.List;

public interface AuthorizationServerContract {
    public String id();

    public String name();

    public String type();

    public String displayName();

    public Boolean useInTestConsole();

    public Boolean useInApiDocumentation();

    public String clientRegistrationEndpoint();

    public String authorizationEndpoint();

    public List<GrantType> grantTypes();

    public String clientId();

    public String clientSecret();

    public String description();

    public List<AuthorizationMethod> authorizationMethods();

    public List<ClientAuthenticationMethod> clientAuthenticationMethod();

    public List<TokenBodyParameterContract> tokenBodyParameters();

    public String tokenEndpoint();

    public Boolean supportState();

    public String defaultScope();

    public List<BearerTokenSendingMethod> bearerTokenSendingMethods();

    public String resourceOwnerUsername();

    public String resourceOwnerPassword();

    public String resourceGroupName();

    public AuthorizationServerContractInner innerModel();

    public Update update();

    public AuthorizationServerContract refresh();

    public AuthorizationServerContract refresh(Context var1);

    public Response<AuthorizationServerSecretsContract> listSecretsWithResponse(Context var1);

    public AuthorizationServerSecretsContract listSecrets();

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithResourceOwnerPassword {
            public Update withResourceOwnerPassword(String var1);
        }

        public static interface WithResourceOwnerUsername {
            public Update withResourceOwnerUsername(String var1);
        }

        public static interface WithBearerTokenSendingMethods {
            public Update withBearerTokenSendingMethods(List<BearerTokenSendingMethod> var1);
        }

        public static interface WithDefaultScope {
            public Update withDefaultScope(String var1);
        }

        public static interface WithSupportState {
            public Update withSupportState(Boolean var1);
        }

        public static interface WithTokenEndpoint {
            public Update withTokenEndpoint(String var1);
        }

        public static interface WithTokenBodyParameters {
            public Update withTokenBodyParameters(List<TokenBodyParameterContract> var1);
        }

        public static interface WithClientAuthenticationMethod {
            public Update withClientAuthenticationMethod(List<ClientAuthenticationMethod> var1);
        }

        public static interface WithAuthorizationMethods {
            public Update withAuthorizationMethods(List<AuthorizationMethod> var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithClientSecret {
            public Update withClientSecret(String var1);
        }

        public static interface WithClientId {
            public Update withClientId(String var1);
        }

        public static interface WithGrantTypes {
            public Update withGrantTypes(List<GrantType> var1);
        }

        public static interface WithAuthorizationEndpoint {
            public Update withAuthorizationEndpoint(String var1);
        }

        public static interface WithClientRegistrationEndpoint {
            public Update withClientRegistrationEndpoint(String var1);
        }

        public static interface WithUseInApiDocumentation {
            public Update withUseInApiDocumentation(Boolean var1);
        }

        public static interface WithUseInTestConsole {
            public Update withUseInTestConsole(Boolean var1);
        }

        public static interface WithDisplayName {
            public Update withDisplayName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithDisplayName,
    UpdateStages.WithUseInTestConsole,
    UpdateStages.WithUseInApiDocumentation,
    UpdateStages.WithClientRegistrationEndpoint,
    UpdateStages.WithAuthorizationEndpoint,
    UpdateStages.WithGrantTypes,
    UpdateStages.WithClientId,
    UpdateStages.WithClientSecret,
    UpdateStages.WithDescription,
    UpdateStages.WithAuthorizationMethods,
    UpdateStages.WithClientAuthenticationMethod,
    UpdateStages.WithTokenBodyParameters,
    UpdateStages.WithTokenEndpoint,
    UpdateStages.WithSupportState,
    UpdateStages.WithDefaultScope,
    UpdateStages.WithBearerTokenSendingMethods,
    UpdateStages.WithResourceOwnerUsername,
    UpdateStages.WithResourceOwnerPassword,
    UpdateStages.WithIfMatch {
        public AuthorizationServerContract apply();

        public AuthorizationServerContract apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithResourceOwnerPassword {
            public WithCreate withResourceOwnerPassword(String var1);
        }

        public static interface WithResourceOwnerUsername {
            public WithCreate withResourceOwnerUsername(String var1);
        }

        public static interface WithBearerTokenSendingMethods {
            public WithCreate withBearerTokenSendingMethods(List<BearerTokenSendingMethod> var1);
        }

        public static interface WithDefaultScope {
            public WithCreate withDefaultScope(String var1);
        }

        public static interface WithSupportState {
            public WithCreate withSupportState(Boolean var1);
        }

        public static interface WithTokenEndpoint {
            public WithCreate withTokenEndpoint(String var1);
        }

        public static interface WithTokenBodyParameters {
            public WithCreate withTokenBodyParameters(List<TokenBodyParameterContract> var1);
        }

        public static interface WithClientAuthenticationMethod {
            public WithCreate withClientAuthenticationMethod(List<ClientAuthenticationMethod> var1);
        }

        public static interface WithAuthorizationMethods {
            public WithCreate withAuthorizationMethods(List<AuthorizationMethod> var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithClientSecret {
            public WithCreate withClientSecret(String var1);
        }

        public static interface WithClientId {
            public WithCreate withClientId(String var1);
        }

        public static interface WithGrantTypes {
            public WithCreate withGrantTypes(List<GrantType> var1);
        }

        public static interface WithAuthorizationEndpoint {
            public WithCreate withAuthorizationEndpoint(String var1);
        }

        public static interface WithClientRegistrationEndpoint {
            public WithCreate withClientRegistrationEndpoint(String var1);
        }

        public static interface WithUseInApiDocumentation {
            public WithCreate withUseInApiDocumentation(Boolean var1);
        }

        public static interface WithUseInTestConsole {
            public WithCreate withUseInTestConsole(Boolean var1);
        }

        public static interface WithDisplayName {
            public WithCreate withDisplayName(String var1);
        }

        public static interface WithCreate
        extends WithDisplayName,
        WithUseInTestConsole,
        WithUseInApiDocumentation,
        WithClientRegistrationEndpoint,
        WithAuthorizationEndpoint,
        WithGrantTypes,
        WithClientId,
        WithClientSecret,
        WithDescription,
        WithAuthorizationMethods,
        WithClientAuthenticationMethod,
        WithTokenBodyParameters,
        WithTokenEndpoint,
        WithSupportState,
        WithDefaultScope,
        WithBearerTokenSendingMethods,
        WithResourceOwnerUsername,
        WithResourceOwnerPassword,
        WithIfMatch {
            public AuthorizationServerContract create();

            public AuthorizationServerContract create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingService(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

