/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.BackendPool;
import com.azure.resourcemanager.apimanagement.models.BackendPoolItem;
import java.io.IOException;
import java.util.List;

public final class BackendBaseParametersPool
extends BackendPool {
    @Override
    public BackendBaseParametersPool withServices(List<BackendPoolItem> services) {
        super.withServices(services);
        return this;
    }

    @Override
    public void validate() {
        if (this.services() != null) {
            this.services().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("services", this.services(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BackendBaseParametersPool fromJson(JsonReader jsonReader) throws IOException {
        return (BackendBaseParametersPool)jsonReader.readObject(reader -> {
            BackendBaseParametersPool deserializedBackendBaseParametersPool = new BackendBaseParametersPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("services".equals(fieldName)) {
                    List services = reader.readArray(reader1 -> BackendPoolItem.fromJson(reader1));
                    deserializedBackendBaseParametersPool.withServices(services);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackendBaseParametersPool;
        });
    }
}

