/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.BackendSubnetConfiguration;
import java.io.IOException;

public final class BackendConfiguration
implements JsonSerializable<BackendConfiguration> {
    private BackendSubnetConfiguration subnet;

    public BackendSubnetConfiguration subnet() {
        return this.subnet;
    }

    public BackendConfiguration withSubnet(BackendSubnetConfiguration subnet) {
        this.subnet = subnet;
        return this;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        return jsonWriter.writeEndObject();
    }

    public static BackendConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (BackendConfiguration)jsonReader.readObject(reader -> {
            BackendConfiguration deserializedBackendConfiguration = new BackendConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnet".equals(fieldName)) {
                    deserializedBackendConfiguration.subnet = BackendSubnetConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackendConfiguration;
        });
    }
}

