/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BackendPoolItem
implements JsonSerializable<BackendPoolItem> {
    private String id;
    private Integer weight;
    private Integer priority;
    private static final ClientLogger LOGGER = new ClientLogger(BackendPoolItem.class);

    public String id() {
        return this.id;
    }

    public BackendPoolItem withId(String id) {
        this.id = id;
        return this;
    }

    public Integer weight() {
        return this.weight;
    }

    public BackendPoolItem withWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public Integer priority() {
        return this.priority;
    }

    public BackendPoolItem withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model BackendPoolItem"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeNumberField("weight", (Number)this.weight);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        return jsonWriter.writeEndObject();
    }

    public static BackendPoolItem fromJson(JsonReader jsonReader) throws IOException {
        return (BackendPoolItem)jsonReader.readObject(reader -> {
            BackendPoolItem deserializedBackendPoolItem = new BackendPoolItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBackendPoolItem.id = reader.getString();
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedBackendPoolItem.weight = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedBackendPoolItem.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackendPoolItem;
        });
    }
}

