/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BackendProxyContract
implements JsonSerializable<BackendProxyContract> {
    private String url;
    private String username;
    private String password;
    private static final ClientLogger LOGGER = new ClientLogger(BackendProxyContract.class);

    public String url() {
        return this.url;
    }

    public BackendProxyContract withUrl(String url) {
        this.url = url;
        return this;
    }

    public String username() {
        return this.username;
    }

    public BackendProxyContract withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public BackendProxyContract withPassword(String password) {
        this.password = password;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model BackendProxyContract"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    public static BackendProxyContract fromJson(JsonReader jsonReader) throws IOException {
        return (BackendProxyContract)jsonReader.readObject(reader -> {
            BackendProxyContract deserializedBackendProxyContract = new BackendProxyContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedBackendProxyContract.url = reader.getString();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedBackendProxyContract.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedBackendProxyContract.password = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackendProxyContract;
        });
    }
}

