/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.CertificateContractInner;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractCreateProperties;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractProperties;
import java.time.OffsetDateTime;

public interface CertificateContract {
    public String id();

    public String name();

    public String type();

    public String subject();

    public String thumbprint();

    public OffsetDateTime expirationDate();

    public KeyVaultContractProperties keyVault();

    public String resourceGroupName();

    public CertificateContractInner innerModel();

    public Update update();

    public CertificateContract refresh();

    public CertificateContract refresh(Context var1);

    public Response<CertificateContract> refreshSecretWithResponse(Context var1);

    public CertificateContract refreshSecret();

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithKeyVault {
            public Update withKeyVault(KeyVaultContractCreateProperties var1);
        }

        public static interface WithPassword {
            public Update withPassword(String var1);
        }

        public static interface WithData {
            public Update withData(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithData,
    UpdateStages.WithPassword,
    UpdateStages.WithKeyVault,
    UpdateStages.WithIfMatch {
        public CertificateContract apply();

        public CertificateContract apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithKeyVault {
            public WithCreate withKeyVault(KeyVaultContractCreateProperties var1);
        }

        public static interface WithPassword {
            public WithCreate withPassword(String var1);
        }

        public static interface WithData {
            public WithCreate withData(String var1);
        }

        public static interface WithCreate
        extends WithData,
        WithPassword,
        WithKeyVault,
        WithIfMatch {
            public CertificateContract create();

            public CertificateContract create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingService(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

