/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class CertificateInformation
implements JsonSerializable<CertificateInformation> {
    private OffsetDateTime expiry;
    private String thumbprint;
    private String subject;
    private static final ClientLogger LOGGER = new ClientLogger(CertificateInformation.class);

    public OffsetDateTime expiry() {
        return this.expiry;
    }

    public CertificateInformation withExpiry(OffsetDateTime expiry) {
        this.expiry = expiry;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public CertificateInformation withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public CertificateInformation withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public void validate() {
        if (this.expiry() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property expiry in model CertificateInformation"));
        }
        if (this.thumbprint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property thumbprint in model CertificateInformation"));
        }
        if (this.subject() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subject in model CertificateInformation"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expiry", this.expiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiry));
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        jsonWriter.writeStringField("subject", this.subject);
        return jsonWriter.writeEndObject();
    }

    public static CertificateInformation fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateInformation)jsonReader.readObject(reader -> {
            CertificateInformation deserializedCertificateInformation = new CertificateInformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expiry".equals(fieldName)) {
                    deserializedCertificateInformation.expiry = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateInformation.thumbprint = reader.getString();
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedCertificateInformation.subject = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateInformation;
        });
    }
}

