/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ConnectivityCheckRequestDestination
implements JsonSerializable<ConnectivityCheckRequestDestination> {
    private String address;
    private long port;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityCheckRequestDestination.class);

    public String address() {
        return this.address;
    }

    public ConnectivityCheckRequestDestination withAddress(String address) {
        this.address = address;
        return this;
    }

    public long port() {
        return this.port;
    }

    public ConnectivityCheckRequestDestination withPort(long port) {
        this.port = port;
        return this;
    }

    public void validate() {
        if (this.address() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property address in model ConnectivityCheckRequestDestination"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeLongField("port", this.port);
        return jsonWriter.writeEndObject();
    }

    public static ConnectivityCheckRequestDestination fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectivityCheckRequestDestination)jsonReader.readObject(reader -> {
            ConnectivityCheckRequestDestination deserializedConnectivityCheckRequestDestination = new ConnectivityCheckRequestDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("address".equals(fieldName)) {
                    deserializedConnectivityCheckRequestDestination.address = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedConnectivityCheckRequestDestination.port = reader.getLong();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivityCheckRequestDestination;
        });
    }
}

