/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ConnectivityCheckRequestSource
implements JsonSerializable<ConnectivityCheckRequestSource> {
    private String region;
    private Long instance;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityCheckRequestSource.class);

    public String region() {
        return this.region;
    }

    public ConnectivityCheckRequestSource withRegion(String region) {
        this.region = region;
        return this;
    }

    public Long instance() {
        return this.instance;
    }

    public ConnectivityCheckRequestSource withInstance(Long instance) {
        this.instance = instance;
        return this;
    }

    public void validate() {
        if (this.region() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property region in model ConnectivityCheckRequestSource"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeNumberField("instance", (Number)this.instance);
        return jsonWriter.writeEndObject();
    }

    public static ConnectivityCheckRequestSource fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectivityCheckRequestSource)jsonReader.readObject(reader -> {
            ConnectivityCheckRequestSource deserializedConnectivityCheckRequestSource = new ConnectivityCheckRequestSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("region".equals(fieldName)) {
                    deserializedConnectivityCheckRequestSource.region = reader.getString();
                    continue;
                }
                if ("instance".equals(fieldName)) {
                    deserializedConnectivityCheckRequestSource.instance = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivityCheckRequestSource;
        });
    }
}

