/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.DiagnosticContractInner;
import com.azure.resourcemanager.apimanagement.models.AlwaysLog;
import com.azure.resourcemanager.apimanagement.models.HttpCorrelationProtocol;
import com.azure.resourcemanager.apimanagement.models.OperationNameFormat;
import com.azure.resourcemanager.apimanagement.models.PipelineDiagnosticSettings;
import com.azure.resourcemanager.apimanagement.models.SamplingSettings;
import com.azure.resourcemanager.apimanagement.models.Verbosity;

public interface DiagnosticContract {
    public String id();

    public String name();

    public String type();

    public AlwaysLog alwaysLog();

    public String loggerId();

    public SamplingSettings sampling();

    public PipelineDiagnosticSettings frontend();

    public PipelineDiagnosticSettings backend();

    public Boolean logClientIp();

    public HttpCorrelationProtocol httpCorrelationProtocol();

    public Verbosity verbosity();

    public OperationNameFormat operationNameFormat();

    public Boolean metrics();

    public String resourceGroupName();

    public DiagnosticContractInner innerModel();

    public Update update();

    public DiagnosticContract refresh();

    public DiagnosticContract refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithMetrics {
            public Update withMetrics(Boolean var1);
        }

        public static interface WithOperationNameFormat {
            public Update withOperationNameFormat(OperationNameFormat var1);
        }

        public static interface WithVerbosity {
            public Update withVerbosity(Verbosity var1);
        }

        public static interface WithHttpCorrelationProtocol {
            public Update withHttpCorrelationProtocol(HttpCorrelationProtocol var1);
        }

        public static interface WithLogClientIp {
            public Update withLogClientIp(Boolean var1);
        }

        public static interface WithBackend {
            public Update withBackend(PipelineDiagnosticSettings var1);
        }

        public static interface WithFrontend {
            public Update withFrontend(PipelineDiagnosticSettings var1);
        }

        public static interface WithSampling {
            public Update withSampling(SamplingSettings var1);
        }

        public static interface WithLoggerId {
            public Update withLoggerId(String var1);
        }

        public static interface WithAlwaysLog {
            public Update withAlwaysLog(AlwaysLog var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithAlwaysLog,
    UpdateStages.WithLoggerId,
    UpdateStages.WithSampling,
    UpdateStages.WithFrontend,
    UpdateStages.WithBackend,
    UpdateStages.WithLogClientIp,
    UpdateStages.WithHttpCorrelationProtocol,
    UpdateStages.WithVerbosity,
    UpdateStages.WithOperationNameFormat,
    UpdateStages.WithMetrics,
    UpdateStages.WithIfMatch {
        public DiagnosticContract apply();

        public DiagnosticContract apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithMetrics {
            public WithCreate withMetrics(Boolean var1);
        }

        public static interface WithOperationNameFormat {
            public WithCreate withOperationNameFormat(OperationNameFormat var1);
        }

        public static interface WithVerbosity {
            public WithCreate withVerbosity(Verbosity var1);
        }

        public static interface WithHttpCorrelationProtocol {
            public WithCreate withHttpCorrelationProtocol(HttpCorrelationProtocol var1);
        }

        public static interface WithLogClientIp {
            public WithCreate withLogClientIp(Boolean var1);
        }

        public static interface WithBackend {
            public WithCreate withBackend(PipelineDiagnosticSettings var1);
        }

        public static interface WithFrontend {
            public WithCreate withFrontend(PipelineDiagnosticSettings var1);
        }

        public static interface WithSampling {
            public WithCreate withSampling(SamplingSettings var1);
        }

        public static interface WithLoggerId {
            public WithCreate withLoggerId(String var1);
        }

        public static interface WithAlwaysLog {
            public WithCreate withAlwaysLog(AlwaysLog var1);
        }

        public static interface WithCreate
        extends WithAlwaysLog,
        WithLoggerId,
        WithSampling,
        WithFrontend,
        WithBackend,
        WithLogClientIp,
        WithHttpCorrelationProtocol,
        WithVerbosity,
        WithOperationNameFormat,
        WithMetrics,
        WithIfMatch {
            public DiagnosticContract create();

            public DiagnosticContract create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingApi(String var1, String var2, String var3);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

