/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ErrorFieldContract;
import java.io.IOException;
import java.util.List;

public final class ErrorResponseBody
implements JsonSerializable<ErrorResponseBody> {
    private String code;
    private String message;
    private List<ErrorFieldContract> details;

    public String code() {
        return this.code;
    }

    public ErrorResponseBody withCode(String code) {
        this.code = code;
        return this;
    }

    public String message() {
        return this.message;
    }

    public ErrorResponseBody withMessage(String message) {
        this.message = message;
        return this;
    }

    public List<ErrorFieldContract> details() {
        return this.details;
    }

    public ErrorResponseBody withDetails(List<ErrorFieldContract> details) {
        this.details = details;
        return this;
    }

    public void validate() {
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ErrorResponseBody fromJson(JsonReader jsonReader) throws IOException {
        return (ErrorResponseBody)jsonReader.readObject(reader -> {
            ErrorResponseBody deserializedErrorResponseBody = new ErrorResponseBody();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedErrorResponseBody.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedErrorResponseBody.message = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedErrorResponseBody.details = details = reader.readArray(reader1 -> ErrorFieldContract.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedErrorResponseBody;
        });
    }
}

