/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.GatewayListDebugCredentialsContractPurpose;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class GatewayListDebugCredentialsContract
implements JsonSerializable<GatewayListDebugCredentialsContract> {
    private Duration credentialsExpireAfter;
    private List<GatewayListDebugCredentialsContractPurpose> purposes;
    private String apiId;
    private static final ClientLogger LOGGER = new ClientLogger(GatewayListDebugCredentialsContract.class);

    public Duration credentialsExpireAfter() {
        return this.credentialsExpireAfter;
    }

    public GatewayListDebugCredentialsContract withCredentialsExpireAfter(Duration credentialsExpireAfter) {
        this.credentialsExpireAfter = credentialsExpireAfter;
        return this;
    }

    public List<GatewayListDebugCredentialsContractPurpose> purposes() {
        return this.purposes;
    }

    public GatewayListDebugCredentialsContract withPurposes(List<GatewayListDebugCredentialsContractPurpose> purposes) {
        this.purposes = purposes;
        return this;
    }

    public String apiId() {
        return this.apiId;
    }

    public GatewayListDebugCredentialsContract withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    public void validate() {
        if (this.purposes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property purposes in model GatewayListDebugCredentialsContract"));
        }
        if (this.apiId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property apiId in model GatewayListDebugCredentialsContract"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("purposes", this.purposes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("apiId", this.apiId);
        jsonWriter.writeStringField("credentialsExpireAfter", CoreUtils.durationToStringWithDays((Duration)this.credentialsExpireAfter));
        return jsonWriter.writeEndObject();
    }

    public static GatewayListDebugCredentialsContract fromJson(JsonReader jsonReader) throws IOException {
        return (GatewayListDebugCredentialsContract)jsonReader.readObject(reader -> {
            GatewayListDebugCredentialsContract deserializedGatewayListDebugCredentialsContract = new GatewayListDebugCredentialsContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("purposes".equals(fieldName)) {
                    List purposes;
                    deserializedGatewayListDebugCredentialsContract.purposes = purposes = reader.readArray(reader1 -> GatewayListDebugCredentialsContractPurpose.fromString(reader1.getString()));
                    continue;
                }
                if ("apiId".equals(fieldName)) {
                    deserializedGatewayListDebugCredentialsContract.apiId = reader.getString();
                    continue;
                }
                if ("credentialsExpireAfter".equals(fieldName)) {
                    deserializedGatewayListDebugCredentialsContract.credentialsExpireAfter = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGatewayListDebugCredentialsContract;
        });
    }
}

