/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.CertificateInformation;
import com.azure.resourcemanager.apimanagement.models.CertificateSource;
import com.azure.resourcemanager.apimanagement.models.CertificateStatus;
import com.azure.resourcemanager.apimanagement.models.HostnameType;
import java.io.IOException;

public final class HostnameConfiguration
implements JsonSerializable<HostnameConfiguration> {
    private HostnameType type;
    private String hostname;
    private String keyVaultId;
    private String identityClientId;
    private String encodedCertificate;
    private String certificatePassword;
    private Boolean defaultSslBinding;
    private Boolean negotiateClientCertificate;
    private CertificateInformation certificate;
    private CertificateSource certificateSource;
    private CertificateStatus certificateStatus;
    private static final ClientLogger LOGGER = new ClientLogger(HostnameConfiguration.class);

    public HostnameType type() {
        return this.type;
    }

    public HostnameConfiguration withType(HostnameType type) {
        this.type = type;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public HostnameConfiguration withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String keyVaultId() {
        return this.keyVaultId;
    }

    public HostnameConfiguration withKeyVaultId(String keyVaultId) {
        this.keyVaultId = keyVaultId;
        return this;
    }

    public String identityClientId() {
        return this.identityClientId;
    }

    public HostnameConfiguration withIdentityClientId(String identityClientId) {
        this.identityClientId = identityClientId;
        return this;
    }

    public String encodedCertificate() {
        return this.encodedCertificate;
    }

    public HostnameConfiguration withEncodedCertificate(String encodedCertificate) {
        this.encodedCertificate = encodedCertificate;
        return this;
    }

    public String certificatePassword() {
        return this.certificatePassword;
    }

    public HostnameConfiguration withCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
        return this;
    }

    public Boolean defaultSslBinding() {
        return this.defaultSslBinding;
    }

    public HostnameConfiguration withDefaultSslBinding(Boolean defaultSslBinding) {
        this.defaultSslBinding = defaultSslBinding;
        return this;
    }

    public Boolean negotiateClientCertificate() {
        return this.negotiateClientCertificate;
    }

    public HostnameConfiguration withNegotiateClientCertificate(Boolean negotiateClientCertificate) {
        this.negotiateClientCertificate = negotiateClientCertificate;
        return this;
    }

    public CertificateInformation certificate() {
        return this.certificate;
    }

    public HostnameConfiguration withCertificate(CertificateInformation certificate) {
        this.certificate = certificate;
        return this;
    }

    public CertificateSource certificateSource() {
        return this.certificateSource;
    }

    public HostnameConfiguration withCertificateSource(CertificateSource certificateSource) {
        this.certificateSource = certificateSource;
        return this;
    }

    public CertificateStatus certificateStatus() {
        return this.certificateStatus;
    }

    public HostnameConfiguration withCertificateStatus(CertificateStatus certificateStatus) {
        this.certificateStatus = certificateStatus;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model HostnameConfiguration"));
        }
        if (this.hostname() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property hostname in model HostnameConfiguration"));
        }
        if (this.certificate() != null) {
            this.certificate().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeStringField("keyVaultId", this.keyVaultId);
        jsonWriter.writeStringField("identityClientId", this.identityClientId);
        jsonWriter.writeStringField("encodedCertificate", this.encodedCertificate);
        jsonWriter.writeStringField("certificatePassword", this.certificatePassword);
        jsonWriter.writeBooleanField("defaultSslBinding", this.defaultSslBinding);
        jsonWriter.writeBooleanField("negotiateClientCertificate", this.negotiateClientCertificate);
        jsonWriter.writeJsonField("certificate", (JsonSerializable)this.certificate);
        jsonWriter.writeStringField("certificateSource", this.certificateSource == null ? null : this.certificateSource.toString());
        jsonWriter.writeStringField("certificateStatus", this.certificateStatus == null ? null : this.certificateStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static HostnameConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (HostnameConfiguration)jsonReader.readObject(reader -> {
            HostnameConfiguration deserializedHostnameConfiguration = new HostnameConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedHostnameConfiguration.type = HostnameType.fromString(reader.getString());
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedHostnameConfiguration.hostname = reader.getString();
                    continue;
                }
                if ("keyVaultId".equals(fieldName)) {
                    deserializedHostnameConfiguration.keyVaultId = reader.getString();
                    continue;
                }
                if ("identityClientId".equals(fieldName)) {
                    deserializedHostnameConfiguration.identityClientId = reader.getString();
                    continue;
                }
                if ("encodedCertificate".equals(fieldName)) {
                    deserializedHostnameConfiguration.encodedCertificate = reader.getString();
                    continue;
                }
                if ("certificatePassword".equals(fieldName)) {
                    deserializedHostnameConfiguration.certificatePassword = reader.getString();
                    continue;
                }
                if ("defaultSslBinding".equals(fieldName)) {
                    deserializedHostnameConfiguration.defaultSslBinding = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("negotiateClientCertificate".equals(fieldName)) {
                    deserializedHostnameConfiguration.negotiateClientCertificate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("certificate".equals(fieldName)) {
                    deserializedHostnameConfiguration.certificate = CertificateInformation.fromJson(reader);
                    continue;
                }
                if ("certificateSource".equals(fieldName)) {
                    deserializedHostnameConfiguration.certificateSource = CertificateSource.fromString(reader.getString());
                    continue;
                }
                if ("certificateStatus".equals(fieldName)) {
                    deserializedHostnameConfiguration.certificateStatus = CertificateStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHostnameConfiguration;
        });
    }
}

