/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.BodyDiagnosticSettings;
import com.azure.resourcemanager.apimanagement.models.DataMasking;
import java.io.IOException;
import java.util.List;

public final class HttpMessageDiagnostic
implements JsonSerializable<HttpMessageDiagnostic> {
    private List<String> headers;
    private BodyDiagnosticSettings body;
    private DataMasking dataMasking;

    public List<String> headers() {
        return this.headers;
    }

    public HttpMessageDiagnostic withHeaders(List<String> headers) {
        this.headers = headers;
        return this;
    }

    public BodyDiagnosticSettings body() {
        return this.body;
    }

    public HttpMessageDiagnostic withBody(BodyDiagnosticSettings body) {
        this.body = body;
        return this;
    }

    public DataMasking dataMasking() {
        return this.dataMasking;
    }

    public HttpMessageDiagnostic withDataMasking(DataMasking dataMasking) {
        this.dataMasking = dataMasking;
        return this;
    }

    public void validate() {
        if (this.body() != null) {
            this.body().validate();
        }
        if (this.dataMasking() != null) {
            this.dataMasking().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("body", (JsonSerializable)this.body);
        jsonWriter.writeJsonField("dataMasking", (JsonSerializable)this.dataMasking);
        return jsonWriter.writeEndObject();
    }

    public static HttpMessageDiagnostic fromJson(JsonReader jsonReader) throws IOException {
        return (HttpMessageDiagnostic)jsonReader.readObject(reader -> {
            HttpMessageDiagnostic deserializedHttpMessageDiagnostic = new HttpMessageDiagnostic();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("headers".equals(fieldName)) {
                    List headers;
                    deserializedHttpMessageDiagnostic.headers = headers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedHttpMessageDiagnostic.body = BodyDiagnosticSettings.fromJson(reader);
                    continue;
                }
                if ("dataMasking".equals(fieldName)) {
                    deserializedHttpMessageDiagnostic.dataMasking = DataMasking.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpMessageDiagnostic;
        });
    }
}

