/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class KeyVaultLastAccessStatusContractProperties
implements JsonSerializable<KeyVaultLastAccessStatusContractProperties> {
    private String code;
    private String message;
    private OffsetDateTime timestampUtc;

    public String code() {
        return this.code;
    }

    public KeyVaultLastAccessStatusContractProperties withCode(String code) {
        this.code = code;
        return this;
    }

    public String message() {
        return this.message;
    }

    public KeyVaultLastAccessStatusContractProperties withMessage(String message) {
        this.message = message;
        return this;
    }

    public OffsetDateTime timestampUtc() {
        return this.timestampUtc;
    }

    public KeyVaultLastAccessStatusContractProperties withTimestampUtc(OffsetDateTime timestampUtc) {
        this.timestampUtc = timestampUtc;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("timeStampUtc", this.timestampUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestampUtc));
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultLastAccessStatusContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultLastAccessStatusContractProperties)jsonReader.readObject(reader -> {
            KeyVaultLastAccessStatusContractProperties deserializedKeyVaultLastAccessStatusContractProperties = new KeyVaultLastAccessStatusContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedKeyVaultLastAccessStatusContractProperties.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedKeyVaultLastAccessStatusContractProperties.message = reader.getString();
                    continue;
                }
                if ("timeStampUtc".equals(fieldName)) {
                    deserializedKeyVaultLastAccessStatusContractProperties.timestampUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultLastAccessStatusContractProperties;
        });
    }
}

